/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.http.client.test;

import junit.framework.Test;
import junit.framework.TestSuite;

import org.eclipse.smila.http.client.test.failover.TestFailoverRestClientNoFailover;
import org.eclipse.smila.http.client.test.failover.TestFailoverRestClientWithFailover;

/**
 * Test suite for org.eclipse.smila.http.client bundle.
 */
public final class AllTests {

  /** name of test bundle. */
  public static final String BUNDLE_ID = "org.eclipse.smila.http.client.test";

  /** Private default Constructor to avoid instance creation. */
  private AllTests() {
  }

  /**
   * Creates test suite.
   */
  public static Test suite() {
    final TestSuite suite = new TestSuite("Tests for org.eclipse.smila.http.client bundle");
    suite.addTestSuite(TestHttpClientUtil.class);
    suite.addTestSuite(TestDefaultRestClient.class);
    suite.addTestSuite(TestResourceHelper.class);
    suite.addTestSuite(TestTaskManagerClientHelper.class);
    suite.addTestSuite(TestFailoverRestClientNoFailover.class);
    suite.addTestSuite(TestFailoverRestClientWithFailover.class);
    return suite;
  }

}
