package org.eclipse.smila.http.client.test.httpserver;

import org.eclipse.smila.http.server.HttpHandler;
import org.eclipse.smila.http.server.JettyHandler;

public interface MultiHttpServerService {

  /**
   * Add a HttpHandler..
   * 
   * @param handler
   *          the new HttpHandler
   */
  void addHttpHandler(final HttpHandler handler);

  /** remove a HttpHandler. */
  void removeHttpHandler(final HttpHandler handler);

  /**
   * start a server with a given port number.
   */
  void start(final int portNumber) throws Exception;

  /**
   * stop a server with a given port number.
   */
  void stop(final int portNumber) throws Exception;

  /** add a JettyHandler. */
  void addJettyHandler(final JettyHandler handler);

  /** remove a JettyHandler. */
  void removeJettyHandler(final JettyHandler handler);
}
