/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.importing.crawler.web.test.httphandler;

import java.io.IOException;

import org.apache.commons.io.IOUtils;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.util.ARequestHandler;

/** A simple handler for waiting during HTTP redirects */
public class WaitHandler extends ARequestHandler {

  @Override
  public void handle(final HttpExchange exchange) {
    try {
      Thread.sleep(100000);
    } catch (final InterruptedException e1) {
      e1.printStackTrace();
    }
    try {
      IOUtils.closeQuietly(exchange.getResponseStream());
    } catch (final IOException e) {
      e.printStackTrace();
    }
  }
}
