/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.importing.httphandler;

import org.eclipse.smila.http.server.json.JsonRequestHandler;
import org.eclipse.smila.importing.DeltaService;

public abstract class ADeltaHandler extends JsonRequestHandler {

  /** reference to used service. */
  protected DeltaService _deltaService;

  /** DS service injection method. */
  public void setDeltaService(final DeltaService deltaService) {
    _deltaService = deltaService;
  }

  /** DS service removal method. */
  public void unsetDeltaService(final DeltaService deltaService) {
    if (_deltaService == deltaService) {
      _deltaService = null;
    }
  }

}
