/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 **********************************************************************************************************************/
package org.eclipse.smila.importing.httphandler;

import java.net.MalformedURLException;
import java.util.Collection;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.importing.DeltaException;

/**
 * ReST API handler for admin operations on DeltaService: get all current sources and remove all sources.
 */
public class DeltaAdminHandler extends ADeltaHandler {

  @Override
  protected boolean isValidMethod(final String method, final String requestUri) {
    return "GET".equals(method) || "DELETE".equals(method);
  }

  @Override
  public Object process(final String method, final String requestUri, final Record inputRecord,
    final HttpExchange exchange) throws Exception {
    if ("DELETE".equals(method)) {
      return clearAllSources();
    } else {
      return getSources(getRequestHost(exchange), requestUri);
    }
  }

  /** remove all sources. */
  private Object clearAllSources() throws DeltaException {
    _deltaService.clearAll();
    return null;
  }

  /** create list of current sources. */
  private AnyMap getSources(final String requestHost, final String requestUri) throws DeltaException,
    MalformedURLException {
    final AnyMap result = DataFactory.DEFAULT.createAnyMap();
    final AnySeq sources = result.getSeq("sources", true);
    final Collection<String> sourceIds = _deltaService.getSourceIds();
    for (final String sourceId : sourceIds) {
      final AnyMap source = sources.getFactory().createAnyMap();
      sources.add(source);
      source.put("id", sourceId);
      source.put("url", URLCreator.create(requestHost, requestUri, sourceId).toString());
    }
    return result;
  }
}
