package org.eclipse.smila.importing.util;

import java.io.File;

import org.apache.commons.io.FilenameUtils;

/** util class for normalizing file paths. */
public final class FilePathNormalizer {

  /** to avoid instantiiation. */
  private FilePathNormalizer() {
  }

  /** @return normalized input (file) path. */
  public static String getNormalizedPath(final File input) {
    final String path = input.getAbsolutePath();
    return getNormalizedPath(path);
  }

  /** @return normalized input (file) path. */
  public static String getNormalizedPath(final String input) {
    // C:\temp -> C:/temp 
    // \temp   -> /temp 
    // /temp/  -> /temp    
    final String normalizedPath = FilenameUtils.normalizeNoEndSeparator(input, true);
    return normalizedPath;
  }

}
