/***********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH.  
 * All rights reserved. This program and the accompanying materials are made available
 * under the terms of the Eclipse Public License v1.0 which accompanies this distribution, 
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial API and implementation               
 **********************************************************************************************************************/

package org.eclipse.smila.ipc.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

import junit.framework.TestCase;

import org.eclipse.smila.ipc.IpcToken;
import org.eclipse.smila.ipc.bon.BinaryFactory;
import org.eclipse.smila.ipc.bon.BinaryStreamWriter;
import org.eclipse.smila.ipc.json.JsonFactory;
import org.eclipse.smila.ipc.json.JsonStreamReader;
import org.eclipse.smila.ipc.util.Ipc2BonTrafo;
import org.eclipse.smila.ipc.util.IpcValidator;
import org.eclipse.smila.utils.config.ConfigUtils;

/**
 * Test for Ipc2BonTrafo class.
 */
public class TestIpc2BonTrafo extends TestCase {

  /** the factory to create JSON reader/writer objects. */
  private final JsonFactory _jsonFactory = new JsonFactory();

  /** the factory to create BON reader/writer objects. */
  private final BinaryFactory _binaryFactory = new BinaryFactory();

  /**
   * special Validator implementation for exactly this JSON input.
   */
  class TestValidator implements IpcValidator {

    /** index var. */
    private int _index;

    /** the expected tokens in the test. */
    private final IpcToken[] _expectedTokens = new IpcToken[] { IpcToken.OBJECT_START, IpcToken.MAPPING_START,
      IpcToken.SCALAR_STRING, IpcToken.MAPPING_START, IpcToken.SCALAR_STRING, IpcToken.MAPPING_START,
      IpcToken.SCALAR_STRING, IpcToken.SCALAR_INT, IpcToken.MAPPING_END, IpcToken.SCALAR_STRING,
      IpcToken.SEQUENCE_START, IpcToken.SCALAR_STRING, IpcToken.SCALAR_STRING, IpcToken.SCALAR_INT,
      IpcToken.SCALAR_INT, IpcToken.SCALAR_STRING, IpcToken.SCALAR_STRING, IpcToken.SCALAR_INT,
      IpcToken.SCALAR_INT, IpcToken.SCALAR_STRING, IpcToken.SCALAR_STRING, IpcToken.SCALAR_INT,
      IpcToken.SCALAR_INT, IpcToken.SEQUENCE_END, IpcToken.MAPPING_END, IpcToken.MAPPING_END, IpcToken.OBJECT_END };

    /** the expected values in the test. */
    private final String[] _expectedValues = new String[] { null, "{", "result", "{", "state", "{", "code", "0",
      "}", "annotations", "[", "Property", "language: startgerman", "0", "13", "Sentence", "", "0", "13", "Token",
      "Heute", "0", "5", "]", "}", "}", null };

    /**
     * {@inheritDoc}
     */
    @Override
    public void validate(IpcToken token, String value) throws IOException {
      assertEquals(_expectedTokens[_index], token);
      assertEquals(_expectedValues[_index], value);
      _index++;
    }
  }

  /**
   * test method for IPC reader/writer interface.
   * 
   * @throws Exception
   *           error
   */
  public void test() throws Exception {
    final InputStream input = ConfigUtils.getConfigStream(AllTests.BUNDLE_ID, "test.json");
    final JsonStreamReader reader = _jsonFactory.newStreamReader(input);
    final ByteArrayOutputStream output = new ByteArrayOutputStream();
    final BinaryStreamWriter writer = _binaryFactory.newStreamWriter(output);
    final Ipc2BonTrafo trafo = new Ipc2BonTrafo(new TestValidator());
    trafo.ipc2bon(reader, writer);
    reader.close();
    writer.close();
  }

  /**
   * test method for stream interface.
   * 
   * @throws IOException
   *           validation error.
   */
  public void testWithStreams() throws IOException {
    final InputStream input = ConfigUtils.getConfigStream(AllTests.BUNDLE_ID, "test.json");
    final ByteArrayOutputStream output = new ByteArrayOutputStream();
    final Ipc2BonTrafo trafo = new Ipc2BonTrafo(new TestValidator());
    trafo.json2bon(input, output);
    input.close();
    output.close();
  }

}
