/***********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial API and implementation
 **********************************************************************************************************************/

package org.eclipse.smila.ipc.test;

import junit.framework.TestCase;

import org.eclipse.smila.ipc.bon.ValueTrafo;

/**
 * Test for ValueTrafo class.
 */
public class TestValueTrafo extends TestCase {

  /**
   * test Long to byte[] conversion.
   */
  public void testLong2Byte() {
    byte[] byteArray = ValueTrafo.long2byte(Integer.MAX_VALUE);
    for (final byte b : byteArray) {
      System.out.println("byte: " + b);
    }
    assertEquals(Integer.MAX_VALUE, ValueTrafo.byte2long(byteArray));

    byteArray = ValueTrafo.long2byte(Long.MAX_VALUE);
    for (final byte b : byteArray) {
      System.out.println("byte: " + b);
    }
    assertEquals(Long.MAX_VALUE, ValueTrafo.byte2long(byteArray));

    byteArray = ValueTrafo.long2byte(1);
    for (final byte b : byteArray) {
      System.out.println("byte: " + b);
    }
    assertEquals(1, ValueTrafo.byte2long(byteArray));
  }

  /**
   * test Double to byte[] conversion.
   */
  public void testDouble2Byte() {
    byte[] byteArray = ValueTrafo.double2byte(Double.MAX_VALUE);
    for (final byte b : byteArray) {
      System.out.println("byte: " + b);
    }
    assertEquals(Double.MAX_VALUE, ValueTrafo.byte2double(byteArray));

    byteArray = ValueTrafo.double2byte(3.14);
    for (final byte b : byteArray) {
      System.out.println("byte: " + b);
    }
    assertEquals(3.14, ValueTrafo.byte2double(byteArray));
  }

  /**
   * test String to byte[] conversion.
   */
  public void testString2Byte() {
    byte[] byteArray = ValueTrafo.string2byte("Eat this!");
    for (final byte b : byteArray) {
      System.out.println("byte: " + b);
    }
    assertEquals("Eat this!", ValueTrafo.byte2string(byteArray));

    byteArray = ValueTrafo.string2byte("");
    for (final byte b : byteArray) {
      System.out.println("byte: " + b);
    }
    assertEquals("", ValueTrafo.byte2string(byteArray));
  }

  /**
   * test String to byte[] conversion with \0.
   */
  public void testString2ByteWithNul() {
    final String testString = "Eat\0000this!";
    byte[] byteArray = ValueTrafo.string2byte(testString);
    for (final byte b : byteArray) {
      System.out.println("byte: " + b);
    }
    assertEquals(testString, ValueTrafo.byte2string(byteArray));

    byteArray = ValueTrafo.string2byte("");
    for (final byte b : byteArray) {
      System.out.println("byte: " + b);
    }
    assertEquals("", ValueTrafo.byte2string(byteArray));
  }
}
