/*******************************************************************************
 * Copyright (c) 2008, 2012 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. 
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Empolis Information Management GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.jdbc.test;

import java.sql.Connection;
import java.util.Properties;

import org.eclipse.smila.jdbc.JdbcProvider;
import org.eclipse.smila.jdbc.internal.JdbcProviderImpl;
import org.eclipse.smila.test.DeclarativeServiceTestCase;

/** test {@link JdbcProviderImpl}. */
public class TestJdbcProvider extends DeclarativeServiceTestCase {
  /** test creating an in-memory derby DB giving user/password via Properties object. */
  public void testDerbyEmbeddedWithProperties() throws Exception {
    final JdbcProvider provider = getService(JdbcProvider.class);
    final Properties props = new Properties();
    props.put("user", "user");
    props.put("password", "user");
    final Connection conn = provider.getConnection("jdbc:derby:memory:testdb1;create=true", props);
    assertNotNull(conn);
    conn.close();
  }

  /** test creating an in-memory derby DB giving user/password via parameters. */
  public void testDerbyEmbeddedWithUserAndPassword() throws Exception {
    final JdbcProvider provider = getService(JdbcProvider.class);
    final Connection conn = provider.getConnection("jdbc:derby:memory:testdb2;create=true", "user", "password");
    assertNotNull(conn);
    conn.close();
  }

  // add necessary driver jars to lib/ and Bundle-ClassPath of org.eclipse.smila.jdbc first to make these tests run.

  public void disabledTestPostgresql() throws Exception {
    final JdbcProvider provider = getService(JdbcProvider.class);
    final Connection conn =
      provider.getConnection("jdbc:postgresql://empgt-dev18/postgres", "postgres", "postgres");
    assertNotNull(conn);
    conn.close();
  }

  public void disabledTestMsSqlServer() throws Exception {
    final JdbcProvider provider = getService(JdbcProvider.class);
    final Connection conn =
      provider.getConnection("jdbc:sqlserver://afa-21069:1433;databaseName=test", "db-testuser", "db-testuser");
    assertNotNull(conn);
    conn.close();

  }
}
