/*******************************************************************************
 * Copyright (c) 2008, 2012 Empolis Information Management GmbH and brox IT Solutions GmbH. All rights reserved. 
 * This program and the accompanying materials are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Empolis Information Management GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

/**
 * interface for a service that can create JDBC connections to databases. Loading of JDBC driver classes is hidden from
 * the client.
 */
public interface JdbcProvider {
  /** create DB connection from url, user and password. */
  Connection getConnection(String url, String user, String password) throws SQLException;

  /**
   * create DB connection from url and properties. The properties should usually contain at least "user" and "password"
   * for authentication.
   */
  Connection getConnection(String url, Properties properties) throws SQLException;
}
