/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/
package org.eclipse.smila.jobmanager.test;

import junit.framework.TestCase;

import org.eclipse.smila.common.definitions.AccessAny;
import org.eclipse.smila.common.exceptions.InvalidDefinitionException;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.jobmanager.definitions.BucketDefinition;

/**
 * Tests for BucketDefinition class.
 */
public class TestBucketDefinition extends TestCase {

  /**
   * tests the conversion of a bucket definition from and to Any.
   * 
   * @throws Exception
   *           error
   */
  public void testToAny() throws Exception {
    final AnyMap bucketAny = AccessAny.FACTORY.createAnyMap();
    bucketAny.put("name", "myName");
    bucketAny.put("type", "myType");
    final AnyMap params = AccessAny.FACTORY.createAnyMap();
    params.put("p1", "v1");
    params.put("p2", "v2");
    bucketAny.put("parameters", params);
    final BucketDefinition b = new BucketDefinition(bucketAny);

    final AnyMap newAny = b.toAny();
    final BucketDefinition newB = new BucketDefinition(newAny);
    assertEquals(newB.getName(), "myName");
    assertEquals(newB.getDataObjectType(), "myType");
    assertEquals(newB.getParameters().get("p1").toString(), "v1");
    assertEquals(newB.getParameters().get("p2").toString(), "v2");
  }

  /**
   * Tests if the BucketDefinition creation fails when "name" property is missing.
   * 
   * @throws Exception
   *           error
   */
  public void testMissingName() throws Exception {
    final AnyMap bucketAny = AccessAny.FACTORY.createAnyMap();
    bucketAny.put("type", "bucket type");
    try {
      new BucketDefinition(bucketAny);
      fail("should not work");
    } catch (final Exception ex) {
      assertTrue("wrong exception caught: " + ex.toString(), ex instanceof InvalidDefinitionException);
    }
  }

  /**
   * Tests if the BucketDefinition creation fails when "name" property is missing.
   * 
   * @throws Exception
   *           error
   */
  public void testInvalidName() throws Exception {
    final AnyMap bucketAny = AccessAny.FACTORY.createAnyMap();
    bucketAny.put("name", "bucket+");
    bucketAny.put("type", "bucket type");
    try {
      new BucketDefinition(bucketAny);
      fail("should not work");
    } catch (final Exception ex) {
      assertTrue("wrong exception caught: " + ex.toString(), ex instanceof InvalidDefinitionException);
    }
  }

  /**
   * Tests if the BucketDefinition creation fails when "type" property is missing.
   * 
   * @throws Exception
   *           error
   */
  public void testMissingType() throws Exception {
    final AnyMap bucketAny = AccessAny.FACTORY.createAnyMap();
    bucketAny.put("name", "bucket");
    try {
      new BucketDefinition(bucketAny);
      fail("should not work");
    } catch (final Exception ex) {
      assertTrue("wrong exception caught: " + ex.toString(), ex instanceof InvalidDefinitionException);
    }
  }
}
