/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.objectstore.test;

import java.io.InputStream;
import java.net.URL;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.io.IOUtils;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.ipc.IpcAnyReader;
import org.eclipse.smila.datamodel.ipc.IpcAnyWriter;
import org.eclipse.smila.datamodel.ipc.IpcRecordReader;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.test.DeclarativeServiceTestCase;

/** base class for ObjectStore http handler tests. */
public abstract class AStoreHandlerTest extends DeclarativeServiceTestCase {

  /** base URL for {@link org.eclipse.smila.objectstore.httphandler.StoreAdminHandler}. */
  protected static final String BASE_URL = "http://localhost:8080/smila/store/";

  /** JSON->Record parser. */
  protected final IpcRecordReader _recordReader = new IpcRecordReader();

  /** JSON->Record parser. */
  protected final IpcAnyReader _anyReader = new IpcAnyReader();

  /** Any->JSON writer. */
  protected final IpcAnyWriter _anyWriter = new IpcAnyWriter();

  /** object store service. */
  protected ObjectStoreService _store;

  /** Http client for requests with methods other than than GET. */
  protected final HttpClient _client = new HttpClient();

  /**
   * {@inheritDoc}
   */
  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _store = getService(ObjectStoreService.class);
    try {
      _store.removeAllStores();
    } catch (final Exception e) {
      ; // ignore and retry again after pausing for a sec or a half.
      Thread.sleep(500);
      _store.removeAllStores();
    }
  }

  /** read JSON from URL. */
  protected AnyMap getUrlContent(final String location) throws Exception {
    final URL url = new URL(location);
    InputStream urlStream = null;
    try {
      urlStream = url.openStream();
      return (AnyMap) _anyReader.readJsonStream(urlStream);
    } finally {
      IOUtils.closeQuietly(urlStream);
    }
  }

}
