/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.objectstore.test;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.http.server.util.RequestHandler;
import org.eclipse.smila.objectstore.httphandler.ObjectStoreServiceHandler;

/**
 * Test class for {@link ObjectStoreServiceHandler}.
 */
public class TestObjectStoreServiceHandler extends AStoreHandlerTest {

  /** URL for {@link ObjectStoreServiceHandler}. */
  private static final String TEST_URL = BASE_URL;

  /** test correct handler implementation class. */
  public void testHandlerInstance() throws Exception {
    final RequestHandler requestHandler = getService(RequestHandler.class, "(uriPattern=/store/?$)");
    assertNotNull(requestHandler);
    assertTrue(requestHandler instanceof ObjectStoreServiceHandler);
  }

  /** test store listing, when no stores exist. */
  public void testNoStores() throws Exception {
    final AnyMap response = getUrlContent(TEST_URL);
    assertTrue(response.containsKey("stores"));
    final AnySeq storeList = response.getSeq("stores");
    assertTrue(storeList.isEmpty());
  }

  /** test store listing, when stores exist. */
  public void testWithStores() throws Exception {
    _store.ensureStore("test1");
    _store.ensureStore("test2");
    _store.ensureStore("test3");
    final AnyMap response = getUrlContent(TEST_URL);
    assertTrue(response.containsKey("stores"));
    final AnySeq storeList = response.getSeq("stores");
    assertEquals(3, storeList.size());
    for (final Any store : storeList) {
      assertTrue(store.isMap());
      final AnyMap storeMap = (AnyMap) store;
      final String name = storeMap.getStringValue("store");
      final String url = storeMap.getStringValue("url");
      assertTrue(name.startsWith("test"));
      assertEquals(TEST_URL + name + "/", url);
    }
  }
}
