/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.objectstore;

import java.io.OutputStream;

/**
 * Extension of Java's {@link OutputStream} to support aborting a created but not yet closed object. The purpose is to
 * tell the {@link ObjectStoreService} that the object this stream writes to should never become visible because it is
 * not valid. See description of {@link #abort()} for details. If {@link #abort()} is not called before {@link #close()}
 * the object will become visible in the store after the call to {@link #close()}.
 * 
 * The {@link java.io.IOException}s thrown by the {@link #write(int)}, {@link #write(byte[])},
 * {@link #write(byte[], int, int)}, {@link #flush()}, and {@link #close()} exceptions may contain
 * {@link ObjectStoreException}s as cause which describe the error in more detail.
 */
public abstract class StoreOutputStream extends OutputStream {

  /**
   * abort the object written to. Must be called before {@link #close()} to prevent the object from becoming visible in
   * the store. After aborting the object, no further write operations are possible.
   */
  public abstract void abort();

}
