/***********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Tobias Liefke - initial API and implementation
 **********************************************************************************************************************/

package org.eclipse.smila.processing.pipelets.test;

import java.io.File;

import org.eclipse.smila.blackboard.Blackboard.Get;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Attachment;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.processing.pipelets.ExecPipelet;

/**
 * Test the ExecPipelet.
 * 
 * @author Tobias Liefke
 */
public class TestExecPipelet extends APipeletTest {

  /** The exec pipelet instance. */
  private ExecPipelet _execPipelet;

  /**
   * {@inheritDoc}
   * 
   * @see junit.framework.TestCase#setUp()
   */
  @Override
  protected void setUp() throws Exception {
    super.setUp();
    _execPipelet = new ExecPipelet();

    // Use Java binary for execution
    final AnyMap configuration = _blackboard.getDataFactory().createAnyMap();
    String binPath = System.getProperty("sun.boot.library.path");
    if (!binPath.endsWith("bin")) {
      // Maybe we are in a lib directory
      binPath = binPath.replaceAll("([\\/])lib\\b.*", "$1bin");
    }
    final String executable;
    if (System.getProperty("os.name").toLowerCase().contains("windows")) {
      executable = new File(binPath, "java.exe").getAbsolutePath();
    } else {
      executable = new File(binPath, "java").getAbsolutePath();
    }
    configuration.put(ExecPipelet.COMMAND_PROPERTY, executable);
    configuration.put(ExecPipelet.PARAMETERS_ATTRIBUTE_PROPERTY, "parameters");
    configuration.put(ExecPipelet.OUTPUT_ATTACHMENT_PROPERTY, "output");
    configuration.put(ExecPipelet.ERROR_ATTACHMENT_PROPERTY, "error");
    configuration.put(ExecPipelet.EXIT_CODE_ATTRIBUTE_PROPERTY, "exitCode");
    configuration.put(ExecPipelet.FAIL_ON_ERROR_PROPERTY, Boolean.TRUE);

    _execPipelet.configure(configuration);
  }

  /**
   * Test execution with a call to the current java executable.
   * 
   * @throws Exception
   *           if the test fails
   */
  public void testExecutionAndOutput() throws Exception {
    // Create the test record
    final Record record = _blackboard.getRecord("testId", Get.AUTO_CREATE);
    final AnyMap metaData = record.getMetadata();
    metaData.getSeq("parameters", true).add("-version");
    _blackboard.setRecord(record);
    final String[] recordIds = new String[] { record.getId() };

    final String[] result = _execPipelet.process(_blackboard, recordIds);
    assertNotNull(result);
    assertEquals(recordIds.length, result.length);

    final Attachment outputAttachment = _blackboard.getAttachment(recordIds[0], "output");
    final Attachment errorAttachment = _blackboard.getAttachment(recordIds[0], "error");
    assertNotNull(outputAttachment);
    assertNotNull(errorAttachment);

    assertEquals(outputAttachment.getAsBytes().length, 0);
    assertTrue("\"java -version\" does not return any version information", new String(
      errorAttachment.getAsBytes(), "ISO-8859-1").contains("version"));
  }

}
