/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. 
 * All rights reserved. This program and the accompanying materials are made available 
 * under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - implementation
 *******************************************************************************/

package org.eclipse.smila.processing.pipelets.test;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.pipelets.RemoveAttributePipelet;

/**
 * Test case for the RemoveAttributePipelet.
 */
public class TestRemoveAttributePipelet extends APipeletTest {

  /**
   * create and configure RemoveAttributePipelet instance.
   */
  public RemoveAttributePipelet createPipelet() throws ProcessingException {
    final RemoveAttributePipelet pipelet = new RemoveAttributePipelet();
    final AnyMap configuration = DataFactory.DEFAULT.createAnyMap();
    configuration.put("removeAttribute", "toBeRemoved");
    pipelet.configure(configuration);
    return pipelet;
  }

  /**
   * Test remove attribute.
   */
  public void testRemoveAttribute() throws Exception {
    final RemoveAttributePipelet pipelet = createPipelet();
    final int noOfRecords = 12;
    final String[] recordIds = new String[noOfRecords];
    for (int i = 0; i < noOfRecords; i++) {
      recordIds[i] = createBlackboardRecord("remove-attr", Integer.toString(i));
      getBlackboard().getMetadata(recordIds[i]).put("hereToStay", "yeah");
      if (i % 2 == 0) {
        getBlackboard().getMetadata(recordIds[i]).put("toBeRemoved", "obsolete");
      }
    }
    final String[] outputRecords = pipelet.process(getBlackboard(), recordIds);
    assertEquals(noOfRecords, outputRecords.length);
    for (int i = 0; i < noOfRecords; i++) {
      assertEquals(recordIds[i], outputRecords[i]);
      assertEquals("yeah", getBlackboard().getMetadata(outputRecords[i]).getStringValue("hereToStay"));
      assertFalse(getBlackboard().getMetadata(outputRecords[i]).containsKey("toBeRemoved"));
    }
  }

}
