/***********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Tobias Liefke - initial API and implementation
 **********************************************************************************************************************/

package org.eclipse.smila.processing.pipelets.test;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.processing.bpel.test.AWorkflowProcessorTest;

/**
 * Test the SetValuePipelet.
 * 
 * @author Tobias Liefke
 */
public class TestSetValuePipelet extends AWorkflowProcessorTest {

  /**
   * Name of the pipeline to test.
   */
  public static final String PIPELINE_NAME = "SetValuePipeline";

  /**
   * @return name of pipeline to test
   */
  @Override
  protected String getPipelineName() {
    return PIPELINE_NAME;
  }

  /**
   * test code.
   * 
   * @throws Exception
   *           test fails
   */
  public void test() throws Exception {
    // Execute Pipeline
    final String requestId = createBlackboardRecord("source", "key");
    final String[] resultIds = getProcessor().process(PIPELINE_NAME, getBlackboard(), new String[] { requestId });
    assertEquals(1, resultIds.length);
    assertEquals(requestId, resultIds[0]);

    // Simple test to create a value in a new attribute
    final DataFactory dataFactory = getBlackboard().getDataFactory();
    final Any attribute1 = getBlackboard().getMetadata(resultIds[0]).get("attribute1");
    assertNotNull(attribute1);
    assertTrue(attribute1.isString());
    assertEquals(attribute1.asValue().asString(), "value1");

    // Complex test to overwrite a value in an existing attribute with a sequence
    final Any attribute2 = getBlackboard().getMetadata(resultIds[0]).get("attribute2");
    assertNotNull(attribute2);
    assertTrue(attribute2.isSeq());
    final AnySeq seq = attribute2.asSeq();
    assertEquals(2, seq.size());
    assertTrue(seq.contains(dataFactory.createStringValue("value3")));
    assertTrue(seq.contains(dataFactory.createStringValue("value4")));
  }
}
