/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - implementation
 *******************************************************************************/
package org.eclipse.smila.processing.worker.test;

import java.io.InputStream;

import org.apache.commons.io.IOUtils;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;

/** test pipelet testing access on attachments in the PipelineProcessorWorker. */
public class BpelWorkerAttachmentTestPipelet implements Pipelet {

  /** the attribute name where we will stow the attachment text. */
  public static final String ATTRIBUTE_ATTACHMENT_TEXT = "attachmentText";

  /** the attribute defining the name of the attachment to stow. */
  public static final String ATTRIBUTE_ATTACHMENT_NAME = "attachmentName";

  /** the attribute name where we will stow the attachment text. */
  public static final String ATTRIBUTE_ATTACHMENT_STREAMCLASS = "attachmentStreamClass";

  /** {@inheritDoc} */
  @Override
  public String[] process(final Blackboard blackboard, final String[] recordIds) throws ProcessingException {
    try {
      for (final String id : recordIds) {
        final AnyMap metadata = blackboard.getMetadata(id);
        final String attachmentName = metadata.getStringValue(ATTRIBUTE_ATTACHMENT_NAME);
        final InputStream attachmentStream = blackboard.getAttachmentAsStream(id, attachmentName);
        try {
          metadata.put(ATTRIBUTE_ATTACHMENT_STREAMCLASS, attachmentStream.getClass().getSimpleName());
          metadata.put(ATTRIBUTE_ATTACHMENT_TEXT, IOUtils.toString(attachmentStream));
        } finally {
          IOUtils.closeQuietly(attachmentStream);
        }
      }
    } catch (final Exception ex) {
      throw new ProcessingException(ex);
    }
    return recordIds;
  }

  /** {@inheritDoc} */
  @Override
  public void configure(final AnyMap configuration) throws ProcessingException {
    ; // nothing to do
  }

}
