/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. 
 * All rights reserved. This program and the accompanying materials are made available 
 * under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - implementation
 *******************************************************************************/
package org.eclipse.smila.processing.worker.test;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;

public class BpelWorkerTestPipelet implements Pipelet {

  public static final String ATTRIBUTE_RECORD_COUNT = "recordCount";

  public static final String ATTRIBUTE_THROW_EXCEPTION = "throwException";

  public static final String ATTRIBUTE_THROW_RECOVERABLE_EXCEPTION = "throwRecoverableException";

  public static int _lastParallelRecordCount; // static for reading result in test

  public static boolean s_throwExceptions = true;

  @Override
  public String[] process(final Blackboard blackboard, final String[] recordIds) throws ProcessingException {
    _lastParallelRecordCount = recordIds.length;
    try {
      for (final String id : recordIds) {
        final AnyMap metadata = blackboard.getMetadata(id);
        if (metadata.containsKey(ATTRIBUTE_THROW_EXCEPTION) && s_throwExceptions) {
          final boolean isRecoverable;
          if (metadata.containsKey(ATTRIBUTE_THROW_RECOVERABLE_EXCEPTION)) {
            isRecoverable = metadata.getBooleanValue(ATTRIBUTE_THROW_RECOVERABLE_EXCEPTION).booleanValue();
          } else {
            isRecoverable = false;
          }
          if (isRecoverable) {
            // reset throwable flag, so next run we won't thor an error for that record.
            s_throwExceptions = false;
          }
          throw new ProcessingException("blabla", isRecoverable);
        }
        metadata.add(ATTRIBUTE_RECORD_COUNT, DataFactory.DEFAULT.createLongValue(_lastParallelRecordCount));
      }
    } catch (final Exception ex) {
      throw new ProcessingException(ex);
    }
    return recordIds;
  }

  @Override
  public void configure(final AnyMap configuration) throws ProcessingException {
    ; // nothing to do
  }

}
