/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Thomas Menzel (brox IT Solution GmbH) - initial creator
 *******************************************************************************/
package org.eclipse.smila.solr;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.xml.XmlSerializationUtils;
import org.eclipse.smila.search.api.SearchResultConstants;
import org.eclipse.smila.solr.search.SolrResultAccessor;

/**
 * 
 * @author tmenzel
 */
public class SolrSearchPipelet_Facet_Test extends SolrSearchPipeletTestBase {

  /**
   */
  @Override
  protected void setUp() throws Exception {
    super.setUp();

    _queryBuilder.setQuery("*:*");
  }

  /**
   * tests a simple facet case where we have 3 docs in the index. 2 have the same facet.
   */
  public void test_FacetSearch_Text() throws Exception {
    // index docs
    addSolrDoc("1", "Facet1");
    final String facetValue2 = "Facet2";
    addSolrDoc("2a", facetValue2);
    addSolrDoc("2b", facetValue2);
    indexAndCommit();

    // setup search
    _queryBuilder.addFacetByAttribute(_solrField, 10);
    _pipelet.process(_blackboard, new String[] { _record.getId() });
    _log.debug("result record: " + XmlSerializationUtils.serialize2string(_record));

    // verify
    final SolrResultAccessor results = new SolrResultAccessor(WORKFLOW, _record);
    final AnySeq resultRecords = results.getResultRecords();
    assertEquals(3, resultRecords.size());

    final AnyMap facets = results.getFacets();
    assertEquals(1, facets.size());
    final AnySeq facetSeq = facets.getSeq(_solrField);
    assertNotNull(facetSeq);

    for (final Any any : facetSeq) {
      if (any.isMap()) {
        final AnyMap facet = any.asMap();
        final String value = facet.getStringValue(SearchResultConstants.VALUE);
        final long count = facet.getLongValue(SearchResultConstants.COUNT);
        if (value.equals(facetValue2)) {
          assertEquals(2, count);
        } else {
          assertEquals(1, count);
        }
      } else if (any.isLong()) {
        final long valueCount = any.asValue().asLong();
        assertEquals(2, valueCount);
      }
    }

  }

}
