/*********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.solr;

import java.util.Arrays;

import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.solr.search.SolrResultAccessor;

/** Tests solr search on dedicated fields. */
public class SolrSearchPipelet_Fields_Test extends SolrSearchPipeletTestBase {

  @Override
  protected void setUp() throws Exception {
    super.setUp();
    // index docs
    addSolrDoc("1", "Filename", "FilenameValue");
    addSolrDoc("2", "Content", "ContentValue");
    addSolrDoc("3", "Title", "TitleValue");
    indexAndCommit();
  }

  /** test (succcessful) search on one dedicated field. */
  public void testQueryWithOneField() throws Exception {
    _queryBuilder.setQueryAttribute("Content", "ContentValue");
    _pipelet.process(_blackboard, new String[] { _record.getId() });
    final SolrResultAccessor results = new SolrResultAccessor(WORKFLOW, _record);
    final AnySeq resultRecords = results.getResultRecords();
    assertEquals("expecting one hit", 1, resultRecords.size());
    assertEquals("2", resultRecords.getMap(0).getStringValue(Record.RECORD_ID));
  }

  /** test (failed) search on one dedicated field. */
  public void testQueryWithOneFieldFailure() throws Exception {
    _queryBuilder.setQueryAttribute("Content", "TitleValue");
    _pipelet.process(_blackboard, new String[] { _record.getId() });
    final SolrResultAccessor results = new SolrResultAccessor(WORKFLOW, _record);
    final AnySeq resultRecords = results.getResultRecords();
    assertEquals("expecting no hits", 0, resultRecords.size());
  }

  /** test search on multiple field. */
  public void testQueryWithMultipleFields() throws Exception {
    _queryBuilder.setQueryAttribute("Content", "ContentValue");
    _queryBuilder.setQueryAttribute("Filename", "FilenameValue");
    _queryBuilder.setQueryAttribute("bla", "bla bla");
    _pipelet.process(_blackboard, new String[] { _record.getId() });
    final SolrResultAccessor results = new SolrResultAccessor(WORKFLOW, _record);
    final AnySeq resultRecords = results.getResultRecords();
    assertEquals("expecting two hits", 2, resultRecords.size());
    assertNotSame(resultRecords.getMap(0).getStringValue(Record.RECORD_ID),
      resultRecords.getMap(1).getStringValue(Record.RECORD_ID));
    assertTrue(Arrays.asList("2", "1").contains(resultRecords.getMap(0).getStringValue(Record.RECORD_ID)));
    assertTrue(Arrays.asList("2", "1").contains(resultRecords.getMap(1).getStringValue(Record.RECORD_ID)));
  }

}
