/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Thomas Menzel (brox IT Solution GmbH) - initial creator
 *******************************************************************************/
package org.eclipse.smila.solr.manual;

import java.io.IOException;

import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrInputDocument;
import org.eclipse.smila.solr.Activator;
import org.eclipse.smila.solr.SolrConstants;
import org.eclipse.smila.solr.SolrManager;
import org.eclipse.smila.solr.SolrSearchPipeletTestBase;

/**
 * 
 * @author tmenzel
 */
public class SolrSearchPipelet_Shards_Test extends SolrSearchPipeletTestBase {

  /**
   */
  @Override
  protected void setUp() throws Exception {
    super.setUp();
  }

  /**
   * as far as i can tell, this is not supported ATM. the test will fail with an solrServerException if no solr is
   * Listening on 8983. once we include the solr servlets into the deployment then this test should work also in
   * embedded mode and should move to the unit test package
   */
  public void _test_MultiCoreSearch_Embedded() throws Exception {
    final SolrManager solrManager = Activator.getInstance().getSolrManager();

    solrManager.getSolrAdministration().create(SolrConstants.DEFAULT_CORE, "Core2");
    final SolrServer solrServer1 = solrManager.getSolrServer(SolrConstants.DEFAULT_CORE);
    final SolrServer solrServer2 = solrManager.getSolrServer("Core2");
    indexDoc(solrServer1, "1");
    indexDoc(solrServer2, "2");

    SolrQuery query = new SolrQuery().setQuery("*:*");
    query.set("shards", "localhost:8983/solr/Core2");

    final QueryResponse response = solrServer1.query(query);
    assertEquals("numFound doesnt match!. did u index the rigth stuff?", 2, response.getResults().getNumFound());

  }

  private SolrInputDocument indexDoc(final SolrServer solrServer, String id) throws SolrServerException,
    IOException {
    final SolrInputDocument inputDocument = new SolrInputDocument();
    inputDocument.setField("Id", id);
    solrServer.add(inputDocument);
    solrServer.commit();
    return inputDocument;
  }

}
