/*******************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Thomas Menzel (brox IT Solution GmbH) - initial creator
 *******************************************************************************/
package org.eclipse.smila.solr.manual;

import junit.framework.TestCase;

import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;

/**
 * these tests investigate how MLT things are done with Solr(J).
 * 
 * @setup run a solr in remote mode on a default config.
 * @author tmenzel
 */
public class Solr_MLT_InvestigationTest extends TestCase {

  /** The logger. */
  private final org.apache.commons.logging.Log _log = org.apache.commons.logging.LogFactory.getLog(this.getClass());

  private CommonsHttpSolrServer _server;

  /**
   * {@inheritDoc}
   * 
   * @see junit.framework.TestCase#setUp()
   */
  @Override
  protected void setUp() throws Exception {
    _server = new CommonsHttpSolrServer("http://localhost:8983/solr/DefaultCore");
    _server.setRequestWriter(new BinaryRequestWriter());

  }

  /**
   * tests MLT as part of a normal query. This does not need anything special in the solrconfig.xml
   */
  public void test_MLT_PartOfSelect() throws Exception {

    final SolrQuery query = new SolrQuery().//
      setQuery("euklid").//
      addField("Size").//
      addField("Id").//
      addField("score");//

    final ModifiableSolrParams params = new ModifiableSolrParams();
    params.set("mlt", true);
    params.set("mlt.fl", "Content");
    params.set("mlt.mindf", 1);
    params.set("mlt.mintf", 1);
    params.set("fl", "score,Id,Folder,Size");
    query.add(params);//

    final QueryResponse response = _server.query(query);
    final NamedList<Object> resLists = response.getResponse();
    final Object mlt = resLists.get("moreLikeThis");
    assertNotNull(mlt);
    SimpleOrderedMap<SolrDocumentList> listOfMltResults = (SimpleOrderedMap<SolrDocumentList>) mlt;
    final SolrDocumentList mltsPerDoc = listOfMltResults.getVal(0);
    assertNotNull(mltsPerDoc);
    final SolrDocument solrDocument = mltsPerDoc.get(0);
    assertNotNull(solrDocument);

  }

  /**
   * tests the MLT handler which must be added to the solrconfig.xml like so
   * <pre> {@code
   *  <requestHandler name="/mlt" class="org.apache.solr.handler.MoreLikeThisHandler">
   *  </requestHandler>
   * }
   * </pre>
   * 
   * @see http://lucene.472066.n3.nabble.com/Using-the-more-like-this-feature-in-solrj-td490057.html
   */
  public void test_MLT_Handler() throws Exception {

    final SolrQuery query = new SolrQuery().//
      // setQueryType("/mlt").//
      setQuery("euklid").//
      addField("Size").//
      addField("Id").//
      addField("score");//

    final ModifiableSolrParams params = new ModifiableSolrParams();
    params.set("qt", "/mlt");
    params.set("version", "2.2");
    params.set("mlt", true);
    params.set("mlt.fl", "Content");
    params.set("mlt.mindf", 1);
    params.set("mlt.mintf", 1);
    // params.set("fl", "score,Id,Folder,Size");
    query.add(params);//

    final QueryResponse response = _server.query(query);
    final NamedList<Object> resLists = response.getResponse();
    final Object mlt = resLists.get("interestingTerms");
    assertNotNull(mlt);

  }

}
