/***********************************************************************************************************************
 * Copyright (c) 2008 empolis GmbH and brox IT Solutions GmbH. All rights reserved. This program and the accompanying
 * materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Peter Wissel (brox IT Solutions GmbH) - initial API and implementation
 **********************************************************************************************************************/

package org.eclipse.smila.solr.search;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.util.AnyUtil;
import org.eclipse.smila.search.api.helper.ResultAccessor;
import org.eclipse.smila.solr.SolrConstants;

/**
 * The SolrResultAccessor.
 * 
 * @author pwissel
 * 
 */
public class SolrResultAccessor extends ResultAccessor {

  /**
   * Constructor.
   * 
   * @param workflowName
   *          the workflow name.
   * @param result
   *          the result record.
   */
  public SolrResultAccessor(String workflowName, Record result) {
    super(workflowName, result);
  }

  /**
   * Get max score.
   * 
   * @return the max score or null.
   */
  public Double getMaxScore() {
    return getSolrResultMap().getDoubleValue(SolrConstants.MAX_SCORE);
  }

  /**
   * Get spellcheck result.
   * 
   * @return the spellcheck result as AnyMap.
   */
  public AnyMap getSpellCheckResult() {
    return getSolrResultMap().getMap(SpellcheckSolrConstants.SPELLCHECK);
  }

  /**
   * Get Terms result.
   * 
   * @return the Map containing the terms or null if not present.
   */
  public AnyMap getTermsResult() {
    return getSolrResultMap().getMap(SolrConstants.TERMS);
  }

  /**
   * 
   * @return the {@link SolrConstants#RESULT_MAP}. Never null but instead empty and immutable.
   */
  private AnyMap getSolrResultMap() {
    final AnyMap map = _result.getMetadata().getMap(SolrConstants.RESULT_MAP);
    return map == null ? AnyUtil.EMPTY_MAP : map;
  }
}
