/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Weber (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/

package org.eclipse.smila.taskmanager.persistence.zk.test;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Suite combining all taskmanager persistence integration tests. 
 */
public final class AllTests {
  /**
   * The Constant BUNDLE_ID.
   */
  public static final String BUNDLE_ID = "org.eclipse.smila.taskmanager.persistence.zk.test";

  /**
   * utility class, do not create instances.
   */
  private AllTests() {
  }

  /**
   * @return suite for all processing.pipelets tests
   */
  public static Test suite() {
    final TestSuite suite = new TestSuite(BUNDLE_ID);
    // $JUnit-BEGIN$
    suite.addTestSuite(TestTaskStorageZk.class);
    suite.addTestSuite(TestTaskStorageZkMultithreaded.class);
    suite.addTestSuite(TestZkTaskQueue.class);
    // $JUnit-END$
    return suite;
  }
}
