/**********************************************************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher, Andreas Weber, Drazen Cindric, Andreas Schank (all Attensity Europe GmbH) - initial
 * implementation
 **********************************************************************************************************************/

package org.eclipse.smila.taskworker.test;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Suite combining all taskworker junit tests.
 */
public final class AllTests {
  /**
   * The Constant BUNDLE_ID.
   */
  public static final String BUNDLE_ID = "org.eclipse.smila.taskworker.test";

  /**
   * utility class, do not create instances.
   */
  private AllTests() {
  }

  /**
   * @return suite for all org.eclipse.smila.taskworker tests
   */
  public static Test suite() {
    final TestSuite suite = new TestSuite(BUNDLE_ID);
    // $JUnit-BEGIN$    
    suite.addTestSuite(TestInputs.class);
    suite.addTestSuite(TestOutputs.class);
    suite.addTestSuite(TestTaskContext.class);
    // $JUnit-END$
    return suite;
  }
}
