/*******************************************************************************
 * Copyright (c) 2008, 2011 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Andreas Schank (Attensity Europe GmbH) - initial implementation
 **********************************************************************************************************************/
package org.eclipse.smila.utils.test;

import junit.framework.TestCase;

import org.eclipse.smila.utils.conversion.DataSizeParser;

/**
 * Testcases for {@link DataSizeParser}.
 */
public class TestDataSizeParser extends TestCase {
  public void testDefaults() throws Exception {
    assertEquals(0, DataSizeParser.parse(null));
    assertEquals(0, DataSizeParser.parse(""));
    assertEquals(42L, DataSizeParser.parse(null, 42));
    assertEquals(42L, DataSizeParser.parse("", 42));
  }

  public void testNoFactor() throws Exception {
    assertEquals(42L, DataSizeParser.parse("42"));
    try {
      DataSizeParser.parse("4.2");
      fail("should not work");
    } catch (final Exception ex) {
      assertTrue("wrong exception: " + ex.toString(), ex instanceof NumberFormatException);
    }
  }

  public void testInvalidFactor() throws Exception {
    try {
      DataSizeParser.parse("42x");
      fail("should not work");
    } catch (final Exception ex) {
      assertTrue("wrong exception: " + ex.toString(), ex instanceof IllegalArgumentException);
    }
  }

  public void testByteFactor() throws Exception {
    assertEquals(42L, DataSizeParser.parse("42b"));
    assertEquals(42L, DataSizeParser.parse("42B"));
    assertEquals(4L, DataSizeParser.parse("4.2b"));
  }

  public void testKibiFactor() throws Exception {
    final long factor = 1024L;
    assertEquals(42 * factor, DataSizeParser.parse("42k"));
    assertEquals(42 * factor, DataSizeParser.parse("42K"));
    assertEquals((long) (4.2 * factor), DataSizeParser.parse("4.2k"));
  }

  public void testMebiFactor() throws Exception {
    final long factor = 1024L * 1024L;
    assertEquals(42 * factor, DataSizeParser.parse("42m"));
    assertEquals(42 * factor, DataSizeParser.parse("42M"));
    assertEquals((long) (4.2 * factor), DataSizeParser.parse("4.2m"));
  }

  public void testGibiFactor() throws Exception {
    final long factor = 1024L * 1024L * 1024L;
    assertEquals(42 * factor, DataSizeParser.parse("42g"));
    assertEquals(42 * factor, DataSizeParser.parse("42G"));
    assertEquals((long) (4.2 * factor), DataSizeParser.parse("4.2g"));
  }

  public void testTebiFactor() throws Exception {
    final long factor = 1024L * 1024L * 1024L * 1024L;
    assertEquals(42 * factor, DataSizeParser.parse("42t"));
    assertEquals(42 * factor, DataSizeParser.parse("42T"));
    assertEquals((long) (4.2 * factor), DataSizeParser.parse("4.2t"));
  }

  public void testPebiFactor() throws Exception {
    final long factor = 1024L * 1024L * 1024L * 1024L * 1024L;
    assertEquals(42 * factor, DataSizeParser.parse("42p"));
    assertEquals(42 * factor, DataSizeParser.parse("42P"));
    assertEquals((long) (4.2 * factor), DataSizeParser.parse("4.2p"));
  }
}
