package org.eclipse.smila.versions.test;

import java.util.Properties;

import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.test.DeclarativeServiceTestCase;
import org.eclipse.smila.versions.VersionProvider;
import org.eclipse.smila.versions.internal.SmilaVersionProvider;

/** Test for {@link SmilaVersionProvider} class. */
public class TestSmilaVersionProvider extends DeclarativeServiceTestCase {

  /** test getVersionInfo() with config. */
  public void testGetVersionInfo() throws Exception {
    final String version = "1.1";
    final Properties versionProps = new Properties();
    versionProps.put(SmilaVersionProvider.PROVIDER_NAME, version);
    final SmilaVersionProvider provider = (SmilaVersionProvider) getService(VersionProvider.class);
    provider.setVersionProperties(versionProps);
    final AnyMap versioninfo = provider.getVersionInfo();
    assertNotNull(versioninfo);
    assertEquals(version, versioninfo.getStringValue(SmilaVersionProvider.PROVIDER_NAME));
  }

  /** test getVersionInfo() without config. */
  public void testGetVersionInfoWithoutConfig() throws Exception {
    final SmilaVersionProvider provider = (SmilaVersionProvider) getService(VersionProvider.class);
    provider.setVersionProperties(null);
    final AnyMap versioninfo = provider.getVersionInfo();
    assertNotNull(versioninfo);
    assertEquals(VersionProvider.VERSION_NOT_AVAILABLE,
      versioninfo.getStringValue(SmilaVersionProvider.PROVIDER_NAME));
  }
}
