package org.eclipse.smila.versions.internal;

import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.versions.VersionProvider;
import org.osgi.service.component.ComponentContext;

/** Implementation of {@link VersionProvider} for getting SMILA version. */
public class SmilaVersionProvider implements VersionProvider {

  public static final String PROVIDER_NAME = "smila";

  /** the bundle name for the configuration. */
  private static final String BUNDLE_NAME = "org.eclipse.smila.versions";

  /** the name of the bundle's configuration file. */
  private static final String CONFIG_FILE_NAME = "version.properties";

  /** local logger. */
  private final Log _log = LogFactory.getLog(getClass());

  private Properties _versionProps;

  @Override
  public AnyMap getVersionInfo() {
    final AnyMap versionInfo = DataFactory.DEFAULT.createAnyMap();
    if (_versionProps != null && !_versionProps.isEmpty()) {
      for (final Object key : _versionProps.keySet()) {
        final String componentName = key.toString();
        versionInfo.put(componentName, _versionProps.getProperty(componentName));
      }
    } else {
      versionInfo.put(PROVIDER_NAME, VERSION_NOT_AVAILABLE);
    }
    return versionInfo;
  }

  /** OSGi Declarative Services service activation method. */
  protected void activate(final ComponentContext context) {
    try {
      final Properties versionProps = ConfigUtils.getConfigProperties(BUNDLE_NAME, CONFIG_FILE_NAME);
      setVersionProperties(versionProps);
    } catch (final Exception e) {
      _log.warn("Could not read version properties", e);
    }
  }

  public void setVersionProperties(final Properties versionProps) {
    _versionProps = versionProps;
  }
}
