/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.helpers;

import java.io.File;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.openrdf.sail.Sail;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SailBase
implements Sail {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final long DEFAULT_CONNECTION_TIMEOUT = 20000L;
    static final String DEBUG_PROP = "org.openrdf.repository.debug";
    private File dataDir;
    private boolean shutDownInProgress = false;
    protected long connectionTimeOut = 20000L;
    private Map<SailConnection, Throwable> activeConnections = new IdentityHashMap<SailConnection, Throwable>();

    protected static boolean debugEnabled() {
        try {
            String value = System.getProperty(DEBUG_PROP);
            return value != null && !value.equals("false");
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public File getDataDir() {
        return this.dataDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SailConnection getConnection() throws SailException {
        if (this.shutDownInProgress) {
            throw new IllegalStateException("shut down in progress");
        }
        SailConnection connection = this.getConnectionInternal();
        Throwable stackTrace = SailBase.debugEnabled() ? new Throwable() : null;
        Map<SailConnection, Throwable> map = this.activeConnections;
        synchronized (map) {
            this.activeConnections.put(connection, stackTrace);
        }
        return connection;
    }

    protected abstract SailConnection getConnectionInternal() throws SailException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() throws SailException {
        this.shutDownInProgress = true;
        Map<SailConnection, Throwable> map = this.activeConnections;
        synchronized (map) {
            if (!this.activeConnections.isEmpty()) {
                this.logger.info("Waiting for active connections to close before shutting down...");
                try {
                    this.activeConnections.wait(20000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            Iterator<Map.Entry<SailConnection, Throwable>> iter = this.activeConnections.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<SailConnection, Throwable> entry = iter.next();
                SailConnection con = entry.getKey();
                Throwable stackTrace = entry.getValue();
                iter.remove();
                if (stackTrace == null) {
                    this.logger.warn("Closing active connection due to shut down; consider setting the {} system property", (Object)DEBUG_PROP);
                } else {
                    this.logger.warn("Closing active connection due to shut down, connection was acquired in", stackTrace);
                }
                try {
                    con.close();
                }
                catch (SailException e) {
                    this.logger.error("Failed to close connection", (Throwable)e);
                }
            }
        }
        try {
            this.shutDownInternal();
        }
        finally {
            this.shutDownInProgress = false;
        }
    }

    protected abstract void shutDownInternal() throws SailException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connectionClosed(SailConnection connection) {
        Map<SailConnection, Throwable> map = this.activeConnections;
        synchronized (map) {
            if (this.activeConnections.containsKey(connection)) {
                this.activeConnections.remove(connection);
                if (this.activeConnections.isEmpty()) {
                    this.activeConnections.notifyAll();
                }
            } else {
                this.logger.warn("tried to remove unknown connection object from store.");
            }
        }
    }
}

