/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.ontology.pipelets;

import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.ontology.pipelets.ASesameRecordPipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.vocabulary.RDF;
import org.openrdf.model.vocabulary.RDFS;
import org.openrdf.query.BindingSet;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public class CreateResourcePipelet
extends ASesameRecordPipelet {
    public static final String PARAM_LABELATTRIBUTE = "labelAttribute";
    public static final String PARAM_URIATTRIBUTE = "uriAttribute";
    public static final String PARAM_LABELPREDICATE = "labelPredicate";
    public static final String PARAM_TYPEURI = "typeUri";
    public static final String PARAM_URIPREFIX = "uriPrefix";

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        if (recordIds != null && recordIds.length > 0) {
            try {
                ParameterAccessor parameters = this.getParameters(blackboard);
                String[] stringArray = recordIds;
                int n = recordIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    parameters.setCurrentRecord(id);
                    try (RepositoryConnection connection = this.getRepositoryConnection(parameters);){
                        try {
                            String labelAttribute = parameters.getRequiredParameter(PARAM_LABELATTRIBUTE);
                            String uriAttribute = parameters.getRequiredParameter(PARAM_URIATTRIBUTE);
                            String typeUriString = parameters.getRequiredParameter(PARAM_TYPEURI);
                            URI typeUri = this.createUri(connection, typeUriString);
                            String labelPredicateString = parameters.getParameter(PARAM_LABELPREDICATE, RDFS.LABEL.stringValue());
                            URI labelPredicate = this.createUri(connection, labelPredicateString);
                            String uriPrefix = parameters.getParameter(PARAM_URIPREFIX, "urn:");
                            Record record = blackboard.getRecord(id);
                            if (record != null) {
                                Any labelAny = (Any)record.getMetadata().get((Object)labelAttribute);
                                record.getMetadata().remove((Object)uriAttribute);
                                if (labelAny != null) {
                                    for (Any valueAny : labelAny) {
                                        String value = valueAny.isString() ? ((org.eclipse.smila.datamodel.Value)valueAny).asString() : valueAny.toString();
                                        URI resource = this.findExistingResource(value, labelPredicate, typeUri, connection);
                                        if (resource == null) {
                                            resource = this.createResource(value, labelPredicate, typeUri, uriPrefix, connection);
                                        }
                                        this.addValue(record.getMetadata(), uriAttribute, resource.stringValue());
                                        blackboard.setRecord(record);
                                    }
                                }
                            }
                            connection.commit();
                        }
                        catch (Exception ex) {
                            throw new ProcessingException("error creating a resourse", (Throwable)ex);
                        }
                    }
                    ++n2;
                }
            }
            catch (RepositoryException ex) {
                throw new ProcessingException("could not get connection to sesame repository", (Throwable)ex);
            }
        }
        return recordIds;
    }

    private void addValue(AnyMap map, String attributeName, String stringValue) {
        if (map.containsKey((Object)attributeName)) {
            Any oldVal = (Any)map.get((Object)attributeName);
            if (oldVal.isSeq()) {
                ((AnySeq)oldVal).add((Object)oldVal.getFactory().createStringValue(stringValue));
            } else {
                AnySeq newSeq = oldVal.getFactory().createAnySeq();
                newSeq.add((Object)oldVal);
                newSeq.add((Object)oldVal.getFactory().createStringValue(stringValue));
                map.put(attributeName, (Any)newSeq);
            }
        } else {
            map.put(attributeName, (Any)map.getFactory().createStringValue(stringValue));
        }
    }

    private URI findExistingResource(String value, URI labelPredicate, URI typeUri, RepositoryConnection connection) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        String sparql = this.createSparql(value, labelPredicate, typeUri);
        TupleQuery query = connection.prepareTupleQuery(QueryLanguage.SPARQL, sparql);
        TupleQueryResult result = query.evaluate();
        URI resource = null;
        if (result.hasNext()) {
            BindingSet binding = (BindingSet)result.next();
            String varName = (String)binding.getBindingNames().iterator().next();
            resource = (URI)binding.getValue(varName);
        }
        result.close();
        return resource;
    }

    private String createSparql(String value, URI labelPredicate, URI typeUri) {
        StringBuilder sparql = new StringBuilder("SELECT ?r ");
        sparql.append("{?r <").append(RDF.TYPE).append("> <").append(typeUri.stringValue()).append("> . ");
        sparql.append("?r <").append(labelPredicate.stringValue()).append("> \"").append(value).append("\" }");
        return sparql.toString();
    }

    private URI createResource(String value, URI labelPredicate, URI typeUri, String uriPrefix, RepositoryConnection connection) throws RepositoryException {
        String uriName = value.replaceAll("\\W", "");
        String uriString = String.valueOf(uriPrefix) + uriName;
        URI uri = this._valueHelper.createUri(connection, uriString);
        connection.add((Resource)uri, RDF.TYPE, (Value)typeUri, new Resource[0]);
        connection.add((Resource)uri, labelPredicate, (Value)connection.getValueFactory().createLiteral(value), new Resource[0]);
        connection.commit();
        return uri;
    }
}

