/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.management.jmx.client.cmd.task.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.management.jmx.client.cmd.task.Task;
import org.eclipse.smila.management.jmx.client.config.RegexpType;
import org.eclipse.smila.management.jmx.client.exceptions.OperationException;
import org.eclipse.smila.management.jmx.client.helpers.JmxConnection;
import org.eclipse.smila.management.jmx.client.helpers.OutWriter;
import org.eclipse.smila.management.jmx.client.helpers.ParameterFormatHelper;

public class RegexpTask
implements Task<RegexpType> {
    private final Log _log = LogFactory.getLog(this.getClass());

    @Override
    public Object execute(RegexpType config, JmxConnection connection, Object globalResult, String[] parameters, Object localResult) throws OperationException {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)ParameterFormatHelper.format(config.getEcho(), globalResult, parameters, localResult));
        }
        if (localResult == null) {
            throw new IllegalArgumentException("Regexp cannot be applied because previous operation result was NULL!");
        }
        Pattern pattern = Pattern.compile(config.getPattern());
        Matcher matcher = pattern.matcher(localResult.toString());
        if (!matcher.matches()) {
            throw new OperationException(String.format("Result [%s] is not matched by regular exception group extractor [%s]", localResult, config.getEcho()));
        }
        if (matcher.groupCount() < config.getGroup()) {
            throw new OperationException(String.format("Result [%s] group [%d] regular exception group extractor [%s] is not found", localResult, config.getGroup(), config.getEcho()));
        }
        String newLocalResult = matcher.group(config.getGroup());
        OutWriter.write(ParameterFormatHelper.format(config.getEcho(), globalResult, parameters, localResult), newLocalResult, this._log);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)"Regexp task successfully finished");
        }
        return newLocalResult;
    }
}

