/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.httphandler;

import java.net.MalformedURLException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.InvalidValueTypeException;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.http.server.HttpExchange;
import org.eclipse.smila.http.server.util.URLCreator;
import org.eclipse.smila.jobmanager.JobRunInfo;
import org.eclipse.smila.jobmanager.definitions.DefinitionPersistence;
import org.eclipse.smila.jobmanager.definitions.JobDefinition;
import org.eclipse.smila.jobmanager.definitions.JobRunMode;
import org.eclipse.smila.jobmanager.exceptions.ConfigNotFoundException;
import org.eclipse.smila.jobmanager.exceptions.IllegalJobStateException;
import org.eclipse.smila.jobmanager.exceptions.JobDependencyException;
import org.eclipse.smila.jobmanager.exceptions.JobManagerException;
import org.eclipse.smila.jobmanager.exceptions.JobRunModeNotAllowedException;
import org.eclipse.smila.jobmanager.httphandler.AJobManagerHandler;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorException;

public class JobHandler
extends AJobManagerHandler {
    public static final String PARAM_RETURNRUNS = "returnRuns";
    public static final String KEY_DEFINITION = "definition";
    public static final String KEY_JOB_ID = "jobId";
    public static final String KEY_STATE = "state";
    public static final String KEY_URL = "url";
    public static final String KEY_CURRENT = "current";
    public static final String KEY_RUNS = "runs";
    public static final String KEY_HISTORY = "history";
    public static final String KEY_MODE = "mode";

    public Object process(String method, String requestUri, Record inputRecord, HttpExchange exchange) throws Exception {
        String jobName = this.getJobName(requestUri);
        DefinitionPersistence defPersistence = this.getDefinitionPersistence();
        String requestHost = this.getRequestHost(exchange);
        if (this.isGetRequest(method)) {
            return this.getJobDefinition(requestHost, requestUri, inputRecord, jobName, defPersistence);
        }
        if (this.isPostRequest(method)) {
            return this.startJob(requestHost, requestUri, inputRecord, jobName);
        }
        if (this.isDeleteRequest(method)) {
            defPersistence.removeJob(jobName);
        }
        return null;
    }

    private Object startJob(String requestHost, String requestUri, Record inputRecord, String jobName) throws JobManagerException, MalformedURLException {
        JobRunMode jobMode = this.getJobModeFromRecord(inputRecord);
        String jobId = this.getJobRunEngine().startJob(jobName, jobMode);
        AnyMap outputAny = FACTORY.createAnyMap();
        outputAny.put(KEY_JOB_ID, jobId);
        outputAny.put(KEY_URL, URLCreator.create((String)requestHost, (String)requestUri, (String)jobId).toString());
        return outputAny;
    }

    private Object getJobDefinition(String requestHost, String requestUri, Record inputRecord, String jobName, DefinitionPersistence defPersistence) throws JobManagerException, MalformedURLException {
        boolean returnDetails = this.getBooleanParameter(inputRecord, "returnDetails", false);
        boolean returnRuns = this.getBooleanParameter(inputRecord, PARAM_RETURNRUNS, true);
        AnyMap outputAny = FACTORY.createAnyMap();
        JobDefinition job = defPersistence.getJob(jobName);
        if (job == null) {
            throw new ConfigNotFoundException("Job '" + jobName + "' not found.");
        }
        outputAny.put(KEY_DEFINITION, (Any)job.toAny(returnDetails));
        if (returnRuns) {
            Collection<String> completedJobRuns;
            AnyMap runsAny = FACTORY.createAnyMap();
            outputAny.put(KEY_RUNS, (Any)runsAny);
            AnyMap currentAny = FACTORY.createAnyMap();
            runsAny.put(KEY_CURRENT, (Any)currentAny);
            JobRunInfo jobRunInfo = this.getJobRunDataProvider().getJobRunInfo(jobName);
            if (jobRunInfo != null) {
                String jobId = jobRunInfo.getId();
                currentAny.put(KEY_JOB_ID, jobId);
                currentAny.put(KEY_STATE, jobRunInfo.getState().toString());
                currentAny.put(KEY_URL, URLCreator.create((String)requestHost, (String)requestUri, (String)jobId).toString());
            }
            if ((completedJobRuns = this.getJobRunDataProvider().getCompletedJobRunIds(jobName)) != null) {
                AnySeq historyAny = FACTORY.createAnySeq();
                for (String completedId : completedJobRuns) {
                    AnyMap singleAny = FACTORY.createAnyMap();
                    singleAny.put(KEY_JOB_ID, completedId);
                    singleAny.put(KEY_URL, URLCreator.create((String)requestHost, (String)requestUri, (String)completedId).toString());
                    historyAny.add(0, (Any)singleAny);
                }
                runsAny.put(KEY_HISTORY, (Any)historyAny);
            }
        }
        return outputAny;
    }

    private boolean getBooleanParameter(Record parameters, String name, boolean defaultValue) {
        if (parameters != null && parameters.getMetadata().containsKey((Object)name)) {
            try {
                return parameters.getMetadata().getBooleanValue(name);
            }
            catch (InvalidValueTypeException invalidValueTypeException) {}
        }
        return defaultValue;
    }

    private JobRunMode getJobModeFromRecord(Record inputRecord) {
        if (inputRecord != null && inputRecord.getMetadata().containsKey((Object)KEY_MODE)) {
            return JobRunMode.valueOf(inputRecord.getMetadata().getStringValue(KEY_MODE).toUpperCase(Locale.US));
        }
        return null;
    }

    @Override
    protected int getErrorStatus(String method, String requestUri, Throwable ex) {
        if (ex instanceof IllegalJobStateException || ex instanceof JobManagerException && ex.getCause() instanceof TaskGeneratorException && ex.getCause().getCause() == null || ex.getCause() instanceof JobRunModeNotAllowedException || ex.getCause() instanceof JobDependencyException) {
            return 400;
        }
        return super.getErrorStatus(method, requestUri, ex);
    }

    private String getJobName(String requestUri) {
        List uriParts = this.getDynamicUriParts(requestUri);
        if (uriParts.size() > 0) {
            return (String)uriParts.get(0);
        }
        throw new IllegalArgumentException("Invalid request URI, does not match uri pattern '" + this.getUriPattern() + "'.");
    }

    @Override
    protected boolean isValidMethod(String method, String requestUri) {
        return this.isGetOrPostRequest(method) || this.isDeleteRequest(method);
    }
}

