/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.jobmanager.taskgenerator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.jobmanager.definitions.Bucket;
import org.eclipse.smila.jobmanager.definitions.JobRunMode;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGenerator;
import org.eclipse.smila.jobmanager.taskgenerator.TaskGeneratorException;
import org.eclipse.smila.objectstore.ObjectStoreService;
import org.eclipse.smila.taskmanager.BulkInfo;
import org.eclipse.smila.taskmanager.Task;
import org.eclipse.smila.taskmanager.TaskCompletionStatus;
import org.osgi.service.component.ComponentContext;

public abstract class TaskGeneratorBase
implements TaskGenerator {
    public static final String PROPERTY_GENERATOR_NAME = "generatorName";
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected ObjectStoreService _objectStore;
    private String _name;

    public static String createTaskId() {
        return UUID.randomUUID().toString();
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public void finishTask(Task task, TaskCompletionStatus taskState) throws TaskGeneratorException {
    }

    protected void activate(ComponentContext context) {
        this._name = context.getProperties().get(PROPERTY_GENERATOR_NAME).toString();
    }

    protected Task createTask(String workerName, AnyMap parameters) {
        String taskId = TaskGeneratorBase.createTaskId();
        Task task = new Task(taskId, workerName);
        task.getParameters().putAll((Map)parameters);
        return task;
    }

    protected void addOutputBulks(Task task, Bucket inputBucket, Map<String, Bucket> outputBuckets, AnyMap variableValues) {
        this.addOutputBulks(task, inputBucket, outputBuckets, variableValues, null);
    }

    protected void addOutputBulks(Task task, Bucket inputBucket, Map<String, Bucket> outputBuckets, AnyMap variableValues, String suffix) {
        for (Map.Entry<String, Bucket> outputs : outputBuckets.entrySet()) {
            String slot = outputs.getKey();
            Bucket bucket = outputs.getValue();
            ArrayList<BulkInfo> bulks = new ArrayList<BulkInfo>();
            bulks.add(bucket.createDataObject(variableValues, suffix));
            task.getOutputBulks().put(slot, bulks);
        }
    }

    protected void checkBucketCounts(Map<String, Bucket> inputBuckets, int expectedNumberOfInputBuckets, Map<String, Bucket> outputBuckets, int expectedNumberOfOutputBuckets) throws TaskGeneratorException {
        if (expectedNumberOfInputBuckets >= 0 && inputBuckets.size() != expectedNumberOfInputBuckets) {
            throw new TaskGeneratorException("Expected exactly " + expectedNumberOfInputBuckets + " input bucket(s), but was: " + inputBuckets.size());
        }
        if (expectedNumberOfOutputBuckets >= 0 && outputBuckets.size() != expectedNumberOfOutputBuckets) {
            throw new TaskGeneratorException("Expected exactly " + expectedNumberOfOutputBuckets + " output bucket(s), but was: " + outputBuckets.size());
        }
    }

    @Override
    public List<Task> createRunOnceTasks(Map<String, Bucket> inputBuckets, Map<String, Bucket> outputBuckets, AnyMap parameters, String workerName) throws TaskGeneratorException {
        throw new TaskGeneratorException("Cannot create tasks for the mode '" + JobRunMode.RUNONCE.name() + "' for worker '" + workerName + "' and input buckets '" + inputBuckets + "'.");
    }

    @Override
    public List<Task> createCompletionTasks(Map<String, Bucket> inputBuckets, Map<String, Bucket> outputBuckets, AnyMap parameters, String workerName) throws TaskGeneratorException {
        this._log.debug((Object)("No completion tasks generated for worker '" + workerName + "'."));
        return Collections.emptyList();
    }

    public void setObjectStoreService(ObjectStoreService objectStore) {
        this._objectStore = objectStore;
    }

    public void unsetObjectStoreService(ObjectStoreService objectStore) {
        if (this._objectStore == objectStore) {
            this._objectStore = null;
        }
    }

    protected int getParameterValue(String parameterValue, int defaultValue) {
        try {
            if (parameterValue != null) {
                return new Integer(parameterValue);
            }
            return defaultValue;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    protected long getParameterValue(String parameterValue, long defaultValue) {
        try {
            if (parameterValue != null) {
                return new Long(parameterValue);
            }
            return defaultValue;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    protected double getParameterValue(String parameterValue, double defaultValue) {
        try {
            if (parameterValue != null) {
                return new Double(parameterValue);
            }
            return defaultValue;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    @Override
    public void validateParameters(AnyMap parameters) throws TaskGeneratorException {
    }

    protected Task createSingleBulkTask(String objectId, String inputSlotName, Bucket inputBucket, Map<String, Bucket> outputBuckets, AnyMap parameters, String workerName) {
        Task task = this.createTask(workerName, parameters);
        task.getInputBulks().put(inputSlotName, Collections.singletonList(new BulkInfo(inputBucket.getBucketDefinition().getName(), inputBucket.getStoreName(), objectId)));
        AnyMap bulkParameters = parameters.getFactory().cloneAnyMap(task.getParameters());
        this.addOutputBulks(task, inputBucket, outputBuckets, bulkParameters);
        return task;
    }
}

