/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.jdbc;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.ImportingException;
import org.eclipse.smila.importing.crawler.jdbc.DbAccessService;
import org.eclipse.smila.importing.crawler.jdbc.JdbcCrawlingContext;
import org.eclipse.smila.importing.util.RecordOutputHandler;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.utils.digest.DigestHelper;

public class JdbcCrawlerWorker
implements Worker {
    public static final String NAME = "jdbcCrawler";
    public static final String OUTPUT_SLOT_CRAWLED_RECORDS = "crawledRecords";
    public static final String TASK_PARAM_MAX_RECORDS_PER_BULK = "maxRecordsPerBulk";
    public static final String TASK_PARAM_DB_URL = "dbUrl";
    public static final String TASK_PARAM_DB_PROPS = "dbProps";
    public static final String TASK_PARAM_CRAWL_SQL = "crawlSql";
    public static final String TASK_PARAM_ID_COLUMNS = "idColumns";
    public static final String TASK_PARAM_DELTA_COLUMNS = "deltaColumns";
    public static final String TASK_PARAM_MAX_ATTACHMENT_SIZE = "maxAttachmentSize";
    public static final Long MAX_RECORDS_PER_BULK_DEFAULT = 1000L;
    public static final Long MAX_ATTACHMENT_SIZE_DEFAULT = 1000000000L;
    private static final String COLUMN_SEPARATOR = "-";
    private final Log _log = LogFactory.getLog(this.getClass());
    private DbAccessService _dbAccess;

    public String getName() {
        return NAME;
    }

    public void perform(TaskContext taskContext) throws Exception {
        try {
            JdbcCrawlingContext crawlContext = new JdbcCrawlingContext(taskContext);
            RecordOutputHandler recordBulks = new RecordOutputHandler(taskContext.getOutputs(), crawlContext.getMaxRecordsPerBulk(), OUTPUT_SLOT_CRAWLED_RECORDS);
            this.crawl(crawlContext, recordBulks);
        }
        catch (Exception e) {
            this._log.error((Object)e);
            throw e;
        }
    }

    public void setDbAccessService(DbAccessService dbAccess) {
        this._dbAccess = dbAccess;
    }

    public void unsetDbAccessService(DbAccessService dbAccess) {
        if (this._dbAccess == dbAccess) {
            this._dbAccess = null;
        }
    }

    private void crawl(JdbcCrawlingContext crawlContext, RecordOutputHandler recordBulks) throws Exception {
        Collection<Record> results = this._dbAccess.executeSql(crawlContext.getDbUrl(), crawlContext.getDbProperties(), crawlContext.getCrawlSql(), crawlContext.getMaxAttachmentSize(), crawlContext.getMessages());
        for (Record record : results) {
            this.augmentRecord(record, crawlContext);
            crawlContext.getMapper().mapNames(record, this.getColumnNames(record));
            recordBulks.writeRecord(record);
        }
    }

    private Record augmentRecord(Record record, JdbcCrawlingContext crawlContext) throws ImportingException {
        record.setId(this.createId(crawlContext, record));
        record.setSource(crawlContext.getDataSource());
        record.getMetadata().put("_deltaHash", this.createDeltaHash(crawlContext, record));
        return record;
    }

    private String createId(JdbcCrawlingContext crawlContext, Record record) throws ImportingException {
        return String.valueOf(crawlContext.getDataSource()) + ":" + this.concatColumnValues(crawlContext.getIdColumns(), record);
    }

    private String createDeltaHash(JdbcCrawlingContext crawlContext, Record record) throws ImportingException {
        return this.concatColumnValues(crawlContext.getDeltaColumns(), record);
    }

    private String concatColumnValues(Any columnNames, Record record) throws ImportingException {
        StringBuffer idBuffer = new StringBuffer();
        if (columnNames != null) {
            AnyMap metadata = record.getMetadata();
            for (Any column : columnNames) {
                String columnName = column.asValue().asString();
                if (metadata.containsKey((Object)columnName)) {
                    String value = metadata.getStringValue(columnName);
                    if (value.length() > 100) {
                        value = DigestHelper.calculateDigest((String)value);
                    }
                    idBuffer.append(value);
                } else if (record.hasAttachment(columnName)) {
                    idBuffer.append(DigestHelper.calculateDigest((byte[])record.getAttachmentAsBytes(columnName)));
                } else {
                    idBuffer.append("NULL");
                }
                idBuffer.append(COLUMN_SEPARATOR);
            }
            idBuffer.deleteCharAt(idBuffer.length() - 1);
        }
        return idBuffer.toString();
    }

    private Set<String> getColumnNames(Record resultRecord) {
        HashSet<String> columnNames = new HashSet<String>();
        columnNames.addAll(resultRecord.getMetadata().keySet());
        columnNames.remove("_recordid");
        columnNames.remove("_source");
        columnNames.remove("_deltaHash");
        Iterator it = resultRecord.getAttachmentNames();
        while (it.hasNext()) {
            columnNames.add((String)it.next());
        }
        return columnNames;
    }
}

