/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.rtrep.v2.xpath10.jaxp;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPathVariableResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.rtrep.v2.EvaluationContext;
import org.apache.ode.bpel.rtrep.v2.OLink;
import org.apache.ode.bpel.rtrep.v2.OMessageVarType;
import org.apache.ode.bpel.rtrep.v2.OScope;
import org.apache.ode.bpel.rtrep.v2.OXsdTypeVarType;
import org.apache.ode.bpel.rtrep.v2.xpath10.OXPath10Expression;
import org.apache.ode.bpel.rtrep.v2.xpath10.OXPath10ExpressionBPEL20;
import org.apache.ode.bpel.rtrep.v2.xpath10.jaxp.WrappedFaultException;
import org.apache.ode.utils.xsd.XSTypes;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JaxpVariableResolver
implements XPathVariableResolver {
    private static final Log __log = LogFactory.getLog(JaxpVariableResolver.class);
    private EvaluationContext _ectx;
    private OXPath10Expression _oxpath;

    public JaxpVariableResolver(EvaluationContext evaluationContext, OXPath10Expression oXPath10Expression) {
        this._ectx = evaluationContext;
        this._oxpath = oXPath10Expression;
    }

    public Object resolveVariable(QName qName) {
        String string;
        String string2;
        __log.debug((Object)("JAXP runtime: Resolving variable " + qName));
        if (!(this._oxpath instanceof OXPath10ExpressionBPEL20)) {
            throw new IllegalStateException("XPath variables not supported for bpel 1.1");
        }
        if (qName.getNamespaceURI().equals("http://www.apache.org/ode/type/extension") && "pid".equals(qName.getLocalPart())) {
            return this._ectx.getProcessId();
        }
        if (this._oxpath instanceof OXPath10ExpressionBPEL20 && ((OXPath10ExpressionBPEL20)this._oxpath).isJoinExpression) {
            OLink oLink = this._oxpath.links.get(qName.getLocalPart());
            try {
                return this._ectx.isLinkActive(oLink) ? Boolean.TRUE : Boolean.FALSE;
            }
            catch (FaultException faultException) {
                throw new WrappedFaultException(faultException);
            }
        }
        int n = qName.getLocalPart().indexOf(46);
        if (n == -1) {
            string2 = qName.getLocalPart();
            string = null;
        } else {
            string2 = qName.getLocalPart().substring(0, n);
            string = qName.getLocalPart().substring(n + 1);
        }
        OScope.Variable variable = this._oxpath.vars.get(string2);
        OMessageVarType.Part part = string == null ? null : ((OMessageVarType)variable.type).parts.get(string);
        try {
            Node node = this._ectx.readVariable(variable, part);
            if (node == null) {
                throw new FaultException(variable.getOwner().constants.qnSelectionFailure, "Unknown variable " + qName.getLocalPart());
            }
            if (this._ectx.narrowTypes()) {
                if (variable.type instanceof OXsdTypeVarType && ((OXsdTypeVarType)variable.type).simple) {
                    return this.getSimpleContent(node, ((OXsdTypeVarType)variable.type).xsdType);
                }
                if (part != null && part.type instanceof OXsdTypeVarType && ((OXsdTypeVarType)part.type).simple) {
                    return this.getSimpleContent(node, ((OXsdTypeVarType)part.type).xsdType);
                }
            }
            return new SingletonNodeList(node);
        }
        catch (FaultException faultException) {
            throw new WrappedFaultException(faultException);
        }
    }

    private Object getSimpleContent(Node node, QName qName) {
        String string = node.getTextContent();
        try {
            return XSTypes.toJavaObject((QName)qName, (String)string);
        }
        catch (Exception exception) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException2) {
                    if (node.getParentNode() != null) {
                        return node.getParentNode().getChildNodes();
                    }
                    return string;
                }
            }
        }
    }

    private static class SingletonNodeList
    implements NodeList {
        private Node _node;

        SingletonNodeList(Node node) {
            this._node = node;
        }

        public Node item(int n) {
            if (n != 0) {
                throw new IndexOutOfBoundsException("" + n);
            }
            return this._node;
        }

        public int getLength() {
            return 1;
        }
    }
}

