/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;

public abstract class StatementNode
extends QueryTreeNode {
    static final int NEED_DDL_ACTIVATION = 5;
    static final int NEED_CURSOR_ACTIVATION = 4;
    static final int NEED_PARAM_ACTIVATION = 2;
    static final int NEED_ROW_ACTIVATION = 1;
    static final int NEED_NOTHING_ACTIVATION = 0;

    public boolean isAtomic() throws StandardException {
        return true;
    }

    public boolean needsSavepoint() {
        return true;
    }

    public String getSPSName() {
        return null;
    }

    public String executeStatementName() {
        return null;
    }

    public String executeSchemaName() {
        return null;
    }

    public ResultDescription makeResultDescription() {
        return null;
    }

    public String toString() {
        return "statementType: " + this.statementToString() + "\n" + super.toString();
    }

    public abstract String statementToString();

    public void bindStatement() throws StandardException {
    }

    public void optimizeStatement() throws StandardException {
    }

    abstract int activationKind();

    protected TableDescriptor lockTableForCompilation(TableDescriptor td) throws StandardException {
        DataDictionary dd = this.getDataDictionary();
        if (dd.getCacheMode() == 1) {
            TransactionController tc = this.getLanguageConnectionContext().getTransactionCompile();
            ConglomerateController heapCC = tc.openConglomerate(td.getHeapConglomerateId(), false, 68, 6, 5);
            heapCC.close();
            String tableName = td.getName();
            td = this.getTableDescriptor(td.getName(), this.getSchemaDescriptor(td.getSchemaName()));
            if (td == null) {
                throw StandardException.newException("42X05", tableName);
            }
        }
        return td;
    }

    public GeneratedClass generate(ByteArray byteCode) throws StandardException {
        String superClass;
        int nodeChoice = this.activationKind();
        switch (nodeChoice) {
            case 4: {
                superClass = "org.apache.derby.impl.sql.execute.CursorActivation";
                break;
            }
            case 5: {
                return this.getClassFactory().loadGeneratedClass("org.apache.derby.impl.sql.execute.ConstantActionActivation", null);
            }
            case 0: 
            case 1: 
            case 2: {
                superClass = "org.apache.derby.impl.sql.execute.BaseActivation";
                break;
            }
            default: {
                throw StandardException.newException("42Z53", String.valueOf(nodeChoice));
            }
        }
        ActivationClassBuilder generatingClass = new ActivationClassBuilder(superClass, this.getCompilerContext());
        MethodBuilder executeMethod = generatingClass.getExecuteMethod();
        MethodBuilder mbWorker = generatingClass.getClassBuilder().newMethodBuilder(2, "org.apache.derby.iapi.sql.ResultSet", "fillResultSet");
        mbWorker.addThrownException("org.apache.derby.iapi.error.StandardException");
        this.generate(generatingClass, mbWorker);
        mbWorker.methodReturn();
        mbWorker.complete();
        executeMethod.pushThis();
        executeMethod.getField("org.apache.derby.impl.sql.execute.BaseActivation", "resultSet", "org.apache.derby.iapi.sql.ResultSet");
        executeMethod.conditionalIfNull();
        executeMethod.pushThis();
        executeMethod.callMethod((short)182, null, "fillResultSet", "org.apache.derby.iapi.sql.ResultSet", 0);
        executeMethod.pushThis();
        executeMethod.swap();
        executeMethod.putField("org.apache.derby.impl.sql.execute.BaseActivation", "resultSet", "org.apache.derby.iapi.sql.ResultSet");
        executeMethod.startElseCode();
        executeMethod.pushThis();
        executeMethod.getField("org.apache.derby.impl.sql.execute.BaseActivation", "resultSet", "org.apache.derby.iapi.sql.ResultSet");
        executeMethod.completeConditional();
        generatingClass.finishExecuteMethod(this instanceof CursorNode);
        generatingClass.finishConstructor();
        try {
            GeneratedClass activationClass = generatingClass.getGeneratedClass(byteCode);
            return activationClass;
        }
        catch (StandardException e) {
            String msgId = e.getMessageId();
            if ("XBCM4.S".equals(msgId) || "XBCM1.S".equals(msgId)) {
                throw StandardException.newException("42ZA0", e);
            }
            throw e;
        }
    }
}

