/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.impl.sql.execute.WriteCursorConstantAction;

public class DeleteConstantAction
extends WriteCursorConstantAction {
    int numColumns;
    ConstantAction[] dependentCActions;
    ResultDescription resultDescription;

    public DeleteConstantAction() {
    }

    public DeleteConstantAction(long conglomId, StaticCompiledOpenConglomInfo heapSCOCI, IndexRowGenerator[] irgs, long[] indexCIDS, StaticCompiledOpenConglomInfo[] indexSCOCIs, ExecRow emptyHeapRow, boolean deferred, UUID targetUUID, int lockMode, FKInfo[] fkInfo, TriggerInfo triggerInfo, FormatableBitSet baseRowReadList, int[] baseRowReadMap, int[] streamStorableHeapColIds, int numColumns, boolean singleRowSource, ResultDescription resultDescription, ConstantAction[] dependentCActions) {
        super(conglomId, heapSCOCI, irgs, indexCIDS, indexSCOCIs, null, deferred, null, targetUUID, lockMode, fkInfo, triggerInfo, emptyHeapRow, baseRowReadList, baseRowReadMap, streamStorableHeapColIds, singleRowSource);
        this.numColumns = numColumns;
        this.resultDescription = resultDescription;
        this.dependentCActions = dependentCActions;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.numColumns = in.readInt();
        this.dependentCActions = new ConstantAction[ArrayUtil.readArrayLength(in)];
        ArrayUtil.readArrayItems(in, this.dependentCActions);
        this.resultDescription = (ResultDescription)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.numColumns);
        ArrayUtil.writeArray(out, this.dependentCActions);
        out.writeObject(this.resultDescription);
    }

    public int getTypeFormatId() {
        return 37;
    }
}

