/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.solr.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.SolrResponseBase;
import org.eclipse.smila.datamodel.Value;

public final class SolrQueryUtils {
    public static final String OR_SEPARATOR = " ";
    public static final String QUERY_WRAPPER_FILTER = "QueryWrapperFilter";
    public static final String ESCAPE_CHARS = "+-&|!(){}[]^~*?:\\\"";
    public static final String ESCAPE_CHARS_WS = "+-&|!(){}[]^~*?:\\\" ";

    private SolrQueryUtils() {
    }

    public static void appendFieldQueryPart(StringBuilder q, String field, List<Value> values) {
        if (field != null && values != null && !values.isEmpty()) {
            if (q.length() > 0) {
                q.append(OR_SEPARATOR);
            }
            q.append(field).append(':');
            if (values.size() > 1) {
                StringBuilder multiValue = new StringBuilder();
                multiValue.append("(");
                for (Value v : values) {
                    if (multiValue.length() > 1) {
                        multiValue.append(OR_SEPARATOR);
                    }
                    multiValue.append(v);
                }
                multiValue.append(")");
                q.append((CharSequence)multiValue);
            } else {
                q.append(values.get(0));
            }
        }
    }

    public static String encodeQuery(String query) throws UnsupportedEncodingException {
        return URLEncoder.encode(query, "UTF-8");
    }

    public static String decodeQuery(String query) throws UnsupportedEncodingException {
        return URLDecoder.decode(query, "UTF-8");
    }

    public static String escapeQuery(String query) {
        return SolrQueryUtils.escapeQuery(query, ESCAPE_CHARS);
    }

    public static String escapeQuery(String query, String escapeChars) {
        if (StringUtils.isEmpty((String)query)) {
            return query;
        }
        int strLength = query.length();
        StringBuilder buf = new StringBuilder(strLength * 2);
        int i = 0;
        while (i < strLength) {
            char ch = query.charAt(i);
            if (escapeChars.indexOf(ch) >= 0) {
                buf.append('\\');
            }
            buf.append(ch);
            ++i;
        }
        if (buf.length() != query.length()) {
            return buf.toString();
        }
        return query;
    }

    public static boolean responseStatusIsError(SolrResponseBase response) throws SolrServerException {
        return response.getStatus() != 0;
    }

    public static String toSolrQueryFilter(String filter) {
        filter = StringUtils.remove((String)filter, (String)QUERY_WRAPPER_FILTER);
        filter = StringUtils.replace((String)filter, (String)"\\", (String)"\\\\");
        return filter;
    }

    public static String toConstQueryOnField(String fieldName, String constant) {
        return String.valueOf(fieldName) + ":\"" + SolrQueryUtils.escapeQuery(constant) + '\"';
    }

    public static String toTokenQueryOnField(String fieldName, String token) {
        return "(" + fieldName + ":" + SolrQueryUtils.escapeQuery(token, ESCAPE_CHARS_WS) + ')';
    }
}

