/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.search.api.helper;

import java.net.InetAddress;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.search.api.QueryConstants;
import org.eclipse.smila.search.api.SearchService;
import org.eclipse.smila.search.api.helper.ResultAccessor;
import org.w3c.dom.Document;

public class QueryBuilder {
    private static String s_localhostIP;
    private final String _workflowName;
    private final Record _query;
    private final DataFactory _factory;

    static {
        try {
            s_localhostIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
        }
    }

    public QueryBuilder(String workflowName) {
        this(workflowName, DataFactory.DEFAULT);
    }

    public QueryBuilder(String workflowName, DataFactory factory) {
        this._workflowName = workflowName;
        this._factory = factory;
        this._query = this._factory.createRecord();
    }

    public QueryBuilder(String workflowName, Record request) {
        this._workflowName = workflowName;
        this._query = request;
        this._factory = request.getFactory();
    }

    public QueryBuilder setId(String id) {
        this._query.setId(id);
        return this;
    }

    public QueryBuilder setQuery(String queryString) {
        this.getMetadata().put("query", (Any)this._factory.createStringValue(queryString));
        return this;
    }

    public QueryBuilder setQueryAttribute(String attributeName, Object ... values) {
        AnyMap attributes;
        Any queryPart = (Any)this.getMetadata().get((Object)"query");
        if (queryPart != null && queryPart.isMap()) {
            attributes = (AnyMap)queryPart;
        } else {
            attributes = this._factory.createAnyMap();
            this.getMetadata().put("query", (Any)attributes);
        }
        if (values.length == 1 && values[0] != null) {
            attributes.put(attributeName, (Any)this._factory.parseFromObject(values[0]));
        } else {
            AnySeq seq = this._factory.createAnySeq();
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                if (value != null) {
                    seq.add((Object)this._factory.parseFromObject(value));
                }
                ++n2;
            }
            attributes.put(attributeName, (Any)seq);
        }
        return this;
    }

    public QueryBuilder setMaxCount(int maxCount) {
        this.getMetadata().put("maxcount", (Any)this._factory.createLongValue(maxCount));
        return this;
    }

    public QueryBuilder setOffset(int offset) {
        this.getMetadata().put("offset", (Any)this._factory.createLongValue(offset));
        return this;
    }

    public QueryBuilder setThreshold(double threshold) {
        this.getMetadata().put("threshold", (Any)this._factory.createDoubleValue(Double.valueOf(threshold)));
        return this;
    }

    public QueryBuilder setLanguage(String language) {
        this.getMetadata().put("language", (Any)this._factory.createStringValue(language));
        return this;
    }

    public QueryBuilder setIndexName(String indexName) {
        this.getMetadata().put("indexname", (Any)this._factory.createStringValue(indexName));
        return this;
    }

    public QueryBuilder setResultAttributes(String ... attributes) {
        AnySeq seq = this._factory.createAnySeq();
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            seq.add((Object)this._factory.createStringValue(attribute));
            ++n2;
        }
        this.getMetadata().put("resultAttributes", (Any)seq);
        return this;
    }

    public QueryBuilder setRanking(Any ranking) {
        this.getMetadata().put("ranking", ranking);
        return this;
    }

    public QueryBuilder addSortBy(String attribute, QueryConstants.SortOrder mode) {
        AnyMap sortByAttribute = this._factory.createAnyMap();
        sortByAttribute.put("order", (Any)this._factory.createStringValue(mode.name().toLowerCase()));
        return this.addAttributeConfig("sortby", attribute, sortByAttribute);
    }

    public QueryBuilder addHighlightByAttribute(String ... attributes) {
        String[] stringArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            this.addHighlightByConfig(attribute, this._factory.createAnyMap());
            ++n2;
        }
        return this;
    }

    public QueryBuilder addHighlightByConfig(String attribute, AnyMap config) {
        return this.addAttributeConfig("highlight", attribute, config);
    }

    public QueryBuilder addFacetByAttribute(String attribute, int maxCount, String sortCriterion, QueryConstants.SortOrder sortOrder) {
        AnyMap facetBy = this._factory.createAnyMap();
        facetBy.put("maxcount", (Any)this._factory.createLongValue(maxCount));
        AnyMap sortBy = this._factory.createAnyMap();
        sortBy.put("criterion", (Any)this._factory.createStringValue(sortCriterion));
        sortBy.put("order", (Any)this._factory.createStringValue(sortOrder.name().toLowerCase()));
        facetBy.put("sortby", (Any)sortBy);
        return this.addFacetByConfig(attribute, facetBy);
    }

    public QueryBuilder addFacetByAttribute(String attribute, int maxCount) {
        AnyMap facetBy = this._factory.createAnyMap();
        facetBy.put("maxcount", (Any)this._factory.createLongValue(maxCount));
        return this.addFacetByConfig(attribute, facetBy);
    }

    public QueryBuilder addFacetByConfig(String attribute, AnyMap config) {
        return this.addAttributeConfig("facetby", attribute, config);
    }

    public QueryBuilder addOneOfFilter(String attribute, Object ... values) {
        return this.addListFilter(attribute, "oneOf", values);
    }

    public QueryBuilder addAllOfFilter(String attribute, Object ... values) {
        return this.addListFilter(attribute, "allOf", values);
    }

    public QueryBuilder addNoneOfFilter(String attribute, Object ... values) {
        return this.addListFilter(attribute, "noneOf", values);
    }

    public QueryBuilder addAtLeastFilter(String attribute, Object value) {
        return this.addBoundFilter(attribute, "atLeast", value);
    }

    public QueryBuilder addAtMostFilter(String attribute, Object value) {
        return this.addBoundFilter(attribute, "atMost", value);
    }

    public QueryBuilder addGreaterThanFilter(String attribute, Object value) {
        return this.addBoundFilter(attribute, "greaterThan", value);
    }

    public QueryBuilder addLessThanFilter(String attribute, Object value) {
        return this.addBoundFilter(attribute, "lessThan", value);
    }

    public QueryBuilder addRangeFilter(String attribute, Object lowerBound, Object upperBound) {
        if (lowerBound == null && upperBound == null) {
            return this;
        }
        AnyMap filter = this._factory.createAnyMap();
        if (lowerBound != null) {
            filter.put("atLeast", (Any)this._factory.parseFromObject(lowerBound));
        }
        if (upperBound != null) {
            filter.put("atMost", (Any)this._factory.parseFromObject(upperBound));
        }
        return this.addFilter(attribute, filter);
    }

    public QueryBuilder addListFilter(String attribute, String filterType, Object ... values) {
        AnyMap filter = this._factory.createAnyMap();
        AnySeq oneOf = this._factory.createAnySeq();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            oneOf.add((Object)this._factory.parseFromObject(value));
            ++n2;
        }
        filter.put(filterType, (Any)oneOf);
        return this.addFilter(attribute, filter);
    }

    public QueryBuilder addBoundFilter(String attribute, String filterType, Object boundValue) {
        AnyMap filter = this._factory.createAnyMap();
        filter.put(filterType, (Any)this._factory.parseFromObject(boundValue));
        return this.addFilter(attribute, filter);
    }

    public QueryBuilder addFilter(String attribute, AnyMap filter) {
        return this.addAttributeConfig("filter", attribute, filter);
    }

    public QueryBuilder addAttributeConfig(String parameterName, String attributeName, AnyMap config) {
        AnySeq paramSeq = this.getMetadata().getSeq(parameterName);
        if (paramSeq == null) {
            paramSeq = this._factory.createAnySeq();
            this.getMetadata().put(parameterName, (Any)paramSeq);
        }
        config.put("attribute", (Any)this._factory.createStringValue(attributeName));
        paramSeq.add((Object)config);
        return this;
    }

    public QueryBuilder setParameter(String name, String value) {
        this.getMetadata().put(name, (Any)this._factory.createStringValue(value));
        return this;
    }

    public QueryBuilder addParameter(String name, String value) {
        AnySeq values;
        if (this.getMetadata().containsKey((Object)name)) {
            Any current = (Any)this.getMetadata().get((Object)name);
            if (current.isSeq()) {
                values = (AnySeq)current;
            } else {
                values = this._factory.createAnySeq();
                values.add((Object)current);
                this.getMetadata().put(name, (Any)values);
            }
        } else {
            values = this._factory.createAnySeq();
            this.getMetadata().put(name, (Any)values);
        }
        values.add((Object)this._factory.createStringValue(value));
        return this;
    }

    public QueryBuilder setAttachment(String name, byte[] attachment) {
        this._query.setAttachment(name, attachment);
        return this;
    }

    public ResultAccessor executeRequest(SearchService searchService) throws ProcessingException {
        this.ensureQueryId();
        Record result = searchService.search(this._workflowName, this._query);
        return new ResultAccessor(this._workflowName, result);
    }

    public Document executeRequestXml(SearchService searchService) throws ParserConfigurationException {
        this.ensureQueryId();
        return searchService.searchAsXml(this._workflowName, this._query);
    }

    public String executeRequestXmlString(SearchService searchService) throws ParserConfigurationException {
        this.ensureQueryId();
        return searchService.searchAsXmlString(this._workflowName, this._query);
    }

    public Record getQuery() {
        return this._query;
    }

    public AnyMap getMetadata() {
        return this._query.getMetadata();
    }

    public String getWorkflowName() {
        return this._workflowName;
    }

    public DataFactory getFactory() {
        return this._factory;
    }

    private void ensureQueryId() {
        if (this._query.getId() == null) {
            String source = s_localhostIP;
            if (source == null) {
                source = this._workflowName;
            }
            String key = UUID.randomUUID().toString();
            String id = String.valueOf(source) + ":" + key;
            this.setId(id);
        }
    }

    public QueryBuilder addResultAttributes(String ... fieldNames) {
        String[] stringArray = fieldNames;
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            Value value = this.getFactory().createStringValue(fieldName);
            this.getMetadata().add("resultAttributes", (Any)value);
            ++n2;
        }
        return this;
    }

    public QueryBuilder addGroupByAttribute(String groupCommand, String attribute, int maxcount) {
        AnyMap config = this.getGroupbyConfigMap(attribute, maxcount);
        this.addGroupByConfig(groupCommand, config);
        return this;
    }

    public QueryBuilder addGroupByConfig(String groupCommand, AnyMap config) {
        AnySeq method = this.getGroupbyMap().getSeq(groupCommand, true);
        method.add((Object)config);
        return this;
    }

    public QueryBuilder addGroupByAttribute(String groupName, String groupCommand, String attribute, int maxcount) {
        AnyMap config = this.getGroupbyConfigMap(attribute, maxcount);
        return this.addGroupByConfig(groupName, groupCommand, config);
    }

    public QueryBuilder addGroupByConfig(String groupName, String groupCommand, AnyMap config) {
        return this.addGroupByConfig(groupName, groupCommand, config, null);
    }

    public QueryBuilder addGroupByAttribute(String groupName, String groupCommand, String attribute, int maxcount, String asMainResult) {
        AnyMap config = this.getGroupbyConfigMap(attribute, maxcount);
        return this.addGroupByConfig(groupName, groupCommand, config, asMainResult);
    }

    public QueryBuilder addGroupByConfig(String groupName, String groupCommand, AnyMap config, String asMainResult) {
        AnyMap name = this.getGroupbyMap().getMap(groupName, true);
        AnySeq method = name.getSeq(groupCommand, true);
        method.add((Object)config);
        if (asMainResult != null) {
            this.getGroupbyMap().put("asMainResult", asMainResult);
        }
        return this;
    }

    private AnyMap getGroupbyMap() {
        return this.getMetadata().getMap("groupby", true);
    }

    private AnyMap getGroupbyConfigMap(String attribute, int maxcount) {
        AnyMap config = this._factory.createAnyMap();
        config.put("attribute", attribute);
        config.put("maxcount", (Any)this._factory.createLongValue(maxcount));
        return config;
    }
}

