/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.web.filter;

import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.importing.util.RegexPatternMatcher;

public class FilterConfiguration {
    public static final String MAX_CRAWL_DEPTH = "maxCrawlDepth";
    public static final String FOLLOW_REDIRECTS = "followRedirects";
    public static final String MAX_REDIRECTS = "maxRedirects";
    public static final String URL_PATTERNS = "urlPatterns";
    public static final String INCLUDE_PATTERNS = "include";
    public static final String EXCLUDE_PATTERNS = "exclude";
    private static final long DEFAULT_NUMBER_OF_REDIRECTS = 1L;
    private long _maxCrawlDepth = Long.MAX_VALUE;
    private boolean _followRedirects;
    private long _maxRedirects = 1L;
    private final RegexPatternMatcher _urlMatcher = new RegexPatternMatcher();

    public FilterConfiguration(AnyMap filterConfig) {
        if (filterConfig.containsKey((Object)MAX_CRAWL_DEPTH)) {
            this._maxCrawlDepth = filterConfig.getLongValue(MAX_CRAWL_DEPTH);
            if (this._maxCrawlDepth < 0L) {
                this._maxCrawlDepth = Long.MAX_VALUE;
            }
        }
        if (filterConfig.containsKey((Object)FOLLOW_REDIRECTS)) {
            this._followRedirects = filterConfig.getBooleanValue(FOLLOW_REDIRECTS);
        }
        if (filterConfig.containsKey((Object)MAX_REDIRECTS)) {
            this._maxRedirects = filterConfig.getLongValue(MAX_REDIRECTS);
            if (this._maxRedirects <= 0L) {
                this._maxRedirects = 1L;
            }
        }
        if (filterConfig.containsKey((Object)URL_PATTERNS)) {
            AnyMap patterns = filterConfig.getMap(URL_PATTERNS);
            if (patterns.containsKey((Object)INCLUDE_PATTERNS)) {
                AnySeq includes = patterns.getSeq(INCLUDE_PATTERNS);
                for (Any include : includes) {
                    this._urlMatcher.addIncludePattern(include.asValue().asString());
                }
            }
            if (patterns.containsKey((Object)EXCLUDE_PATTERNS)) {
                AnySeq excludes = patterns.getSeq(EXCLUDE_PATTERNS);
                for (Any exclude : excludes) {
                    this._urlMatcher.addExcludePattern(exclude.asValue().asString());
                }
            }
        }
    }

    public RegexPatternMatcher getUrlPatternMatcher() {
        return this._urlMatcher;
    }

    public boolean followRedirects() {
        return this._followRedirects;
    }

    public long getMaxRedirects() {
        return this._maxRedirects;
    }

    public long getMaxCrawlDepth() {
        return this._maxCrawlDepth;
    }
}

