/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.webservice;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.ws.Endpoint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.utils.config.ConfigUtils;
import org.eclipse.smila.webservice.WebserviceProperties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class WebservicePublisher
extends ServiceTracker {
    public static final String PROP_WEBSERVICENAME = "org.eclipse.smila.ws";
    public static final String PROPERTY_FILENAME = "webservice.properties";
    private final Map<String, ServiceReference> _references = new HashMap<String, ServiceReference>();
    private final Map<String, Endpoint> _endpoints = new HashMap<String, Endpoint>();
    private WebserviceProperties _properties;
    private final Log _log = LogFactory.getLog(((Object)((Object)this)).getClass());

    public WebservicePublisher(BundleContext bundleContext) {
        super(bundleContext, WebservicePublisher.createFilter(bundleContext), null);
    }

    private static Filter createFilter(BundleContext bundleContext) {
        try {
            return bundleContext.createFilter("(org.eclipse.smila.ws=*)");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new RuntimeException("should not happen");
        }
    }

    public void open() {
        try {
            InputStream stream = ConfigUtils.getConfigStream((String)"org.eclipse.smila.webservice", (String)PROPERTY_FILENAME);
            this._properties = new WebserviceProperties(stream);
            stream.close();
        }
        catch (Exception exception) {
            this._log.error((Object)"Error reading webservice.properties, using defaults.");
            this._properties = new WebserviceProperties();
        }
        super.open();
    }

    public void close() {
        super.close();
        for (Endpoint endpoint : this._endpoints.values()) {
            try {
                endpoint.stop();
            }
            catch (RuntimeException ex) {
                this._log.warn((Object)"error while shutting down", (Throwable)ex);
            }
        }
        this._endpoints.clear();
        this._references.clear();
    }

    public Object addingService(ServiceReference reference) {
        Object implementor = super.addingService(reference);
        this.publishWebservice(reference, implementor);
        return implementor;
    }

    public void removedService(ServiceReference reference, Object service) {
        super.removedService(reference, service);
        this.stopWebservice(reference);
    }

    public void publishWebservice(ServiceReference reference, Object implementor) {
        String name = reference.getProperty(PROP_WEBSERVICENAME).toString();
        if (this._endpoints.containsKey(name)) {
            this._log.warn((Object)("Already have registered a Webservice endpoint with name " + name + ", ignoring new service."));
        } else {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(implementor.getClass().getClassLoader());
            try {
                try {
                    this._log.debug((Object)("Creating endpoint for webservice " + name));
                    Endpoint ep = Endpoint.create((Object)implementor);
                    if (ep != null) {
                        String url = String.valueOf(this._properties.getBaseURL()) + name;
                        this._log.debug((Object)("Publishing webservice " + name + " at " + url));
                        ep.publish(url);
                        this._endpoints.put(name, ep);
                        this._references.put(name, reference);
                        this._log.info((Object)("Webservice successfully published: " + url));
                    }
                }
                catch (Throwable ex) {
                    this._log.error((Object)("Error publishing webservice " + name), ex);
                    Thread.currentThread().setContextClassLoader(tccl);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
    }

    public void stopWebservice(ServiceReference reference) {
        String name = reference.getProperty(PROP_WEBSERVICENAME).toString();
        ServiceReference publishedRef = this._references.get(name);
        if (reference.equals(publishedRef)) {
            try {
                Endpoint ep = this._endpoints.get(name);
                if (ep != null) {
                    this._log.debug((Object)("Stopping webservice " + name));
                    ep.stop();
                    this._endpoints.remove(name);
                    this._references.remove(name);
                    this._log.info((Object)("Webservice " + name + " successfully stopped."));
                }
            }
            catch (Throwable ex) {
                this._log.error((Object)("Error stopping webservice " + name), ex);
            }
        } else {
            this._log.warn((Object)("Service reference for webservice " + name + " differs from removed reference, ignoring event."));
        }
    }
}

