/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.io.File;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.BpelEventFilter;
import org.apache.ode.bpel.common.Filter;
import org.apache.ode.bpel.common.InstanceFilter;
import org.apache.ode.bpel.common.ProcessFilter;
import org.apache.ode.bpel.dao.ActivityRecoveryDAO;
import org.apache.ode.bpel.dao.BpelDAOConnection;
import org.apache.ode.bpel.dao.CorrelationSetDAO;
import org.apache.ode.bpel.dao.PartnerLinkDAO;
import org.apache.ode.bpel.dao.ProcessDAO;
import org.apache.ode.bpel.dao.ProcessInstanceDAO;
import org.apache.ode.bpel.dao.ScopeDAO;
import org.apache.ode.bpel.dao.XmlDataDAO;
import org.apache.ode.bpel.engine.BpelDatabase;
import org.apache.ode.bpel.engine.BpelManagementFacadeImpl;
import org.apache.ode.bpel.engine.BpelProcessDatabase;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.engine.DebuggerSupport;
import org.apache.ode.bpel.engine.DocumentInfoGenerator;
import org.apache.ode.bpel.engine.Messages;
import org.apache.ode.bpel.engine.ODEProcess;
import org.apache.ode.bpel.engine.ProcessStatusConverter;
import org.apache.ode.bpel.evt.ActivityEvent;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.evt.CorrelationEvent;
import org.apache.ode.bpel.evt.CorrelationMatchEvent;
import org.apache.ode.bpel.evt.CorrelationSetEvent;
import org.apache.ode.bpel.evt.CorrelationSetWriteEvent;
import org.apache.ode.bpel.evt.ExpressionEvaluationEvent;
import org.apache.ode.bpel.evt.ExpressionEvaluationFailedEvent;
import org.apache.ode.bpel.evt.NewProcessInstanceEvent;
import org.apache.ode.bpel.evt.PartnerLinkEvent;
import org.apache.ode.bpel.evt.ProcessCompletionEvent;
import org.apache.ode.bpel.evt.ProcessEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.evt.ProcessInstanceStartedEvent;
import org.apache.ode.bpel.evt.ProcessInstanceStateChangeEvent;
import org.apache.ode.bpel.evt.ProcessMessageExchangeEvent;
import org.apache.ode.bpel.evt.ScopeCompletionEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.ScopeFaultEvent;
import org.apache.ode.bpel.evt.VariableEvent;
import org.apache.ode.bpel.evtproc.ActivityStateDocumentBuilder;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.BpelServer;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.bpel.pmapi.ActivityExtInfoListDocument;
import org.apache.ode.bpel.pmapi.ActivityInfoDocument;
import org.apache.ode.bpel.pmapi.EventInfoListDocument;
import org.apache.ode.bpel.pmapi.InstanceInfoDocument;
import org.apache.ode.bpel.pmapi.InstanceInfoListDocument;
import org.apache.ode.bpel.pmapi.InstanceManagement;
import org.apache.ode.bpel.pmapi.InstanceNotFoundException;
import org.apache.ode.bpel.pmapi.InvalidRequestException;
import org.apache.ode.bpel.pmapi.ManagementException;
import org.apache.ode.bpel.pmapi.ProcessInfoCustomizer;
import org.apache.ode.bpel.pmapi.ProcessInfoDocument;
import org.apache.ode.bpel.pmapi.ProcessInfoListDocument;
import org.apache.ode.bpel.pmapi.ProcessManagement;
import org.apache.ode.bpel.pmapi.ProcessNotFoundException;
import org.apache.ode.bpel.pmapi.ProcessingException;
import org.apache.ode.bpel.pmapi.ScopeInfoDocument;
import org.apache.ode.bpel.pmapi.TActivityExtInfo;
import org.apache.ode.bpel.pmapi.TActivityStatus;
import org.apache.ode.bpel.pmapi.TActivitytExtInfoList;
import org.apache.ode.bpel.pmapi.TCorrelationProperty;
import org.apache.ode.bpel.pmapi.TDefinitionInfo;
import org.apache.ode.bpel.pmapi.TDeploymentInfo;
import org.apache.ode.bpel.pmapi.TDocumentInfo;
import org.apache.ode.bpel.pmapi.TEndpointReferences;
import org.apache.ode.bpel.pmapi.TEventInfo;
import org.apache.ode.bpel.pmapi.TEventInfoList;
import org.apache.ode.bpel.pmapi.TFailureInfo;
import org.apache.ode.bpel.pmapi.TFailuresInfo;
import org.apache.ode.bpel.pmapi.TFaultInfo;
import org.apache.ode.bpel.pmapi.TInstanceInfo;
import org.apache.ode.bpel.pmapi.TInstanceInfoList;
import org.apache.ode.bpel.pmapi.TInstanceStatus;
import org.apache.ode.bpel.pmapi.TInstanceSummary;
import org.apache.ode.bpel.pmapi.TProcessInfo;
import org.apache.ode.bpel.pmapi.TProcessInfoList;
import org.apache.ode.bpel.pmapi.TProcessProperties;
import org.apache.ode.bpel.pmapi.TProcessStatus;
import org.apache.ode.bpel.pmapi.TScopeInfo;
import org.apache.ode.bpel.pmapi.TScopeRef;
import org.apache.ode.bpel.pmapi.TVariableInfo;
import org.apache.ode.bpel.pmapi.TVariableRef;
import org.apache.ode.bpel.pmapi.VariableInfoDocument;
import org.apache.ode.bpel.rapi.ActivityModel;
import org.apache.ode.bpel.rapi.PartnerLinkModel;
import org.apache.ode.bpel.rapi.ProcessModel;
import org.apache.ode.utils.ISO8601DateParser;
import org.apache.ode.utils.msg.MessageBundle;
import org.apache.ode.utils.stl.CollectionsX;
import org.apache.ode.utils.stl.MemberOfFunction;
import org.apache.ode.utils.stl.UnaryFunction;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessAndInstanceManagementImpl
implements InstanceManagement,
ProcessManagement {
    protected static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    protected static Log __log = LogFactory.getLog(BpelManagementFacadeImpl.class);
    protected static final ProcessStatusConverter __psc = new ProcessStatusConverter();
    protected BpelDatabase _db;
    protected ProcessStore _store;
    protected Calendar _calendar = Calendar.getInstance();
    protected BpelServerImpl _server;

    public ProcessAndInstanceManagementImpl(BpelServer bpelServer, ProcessStore processStore) {
        this._server = (BpelServerImpl)bpelServer;
        this._db = this._server._db;
        this._store = processStore;
    }

    public ProcessInfoListDocument listProcessesCustom(String string, String string2, ProcessInfoCustomizer processInfoCustomizer) {
        ProcessInfoListDocument processInfoListDocument = ProcessInfoListDocument.Factory.newInstance();
        TProcessInfoList tProcessInfoList = processInfoListDocument.addNewProcessInfoList();
        ProcessFilter processFilter = new ProcessFilter(string, string2);
        for (ProcessConf processConf : this.processQuery(processFilter)) {
            try {
                this.fillProcessInfo(tProcessInfoList.addNewProcessInfo(), processConf, processInfoCustomizer);
            }
            catch (Exception exception) {
                __log.error((Object)("Exception when querying process " + processConf.getProcessId()), (Throwable)exception);
            }
        }
        return processInfoListDocument;
    }

    public ProcessInfoListDocument listProcesses(String string, String string2) {
        return this.listProcessesCustom(string, string2, ProcessInfoCustomizer.ALL);
    }

    public ProcessInfoListDocument listAllProcesses() {
        return this.listProcessesCustom(null, null, ProcessInfoCustomizer.ALL);
    }

    public ProcessInfoDocument getProcessInfoCustom(QName qName, ProcessInfoCustomizer processInfoCustomizer) {
        return this.genProcessInfoDocument(qName, processInfoCustomizer);
    }

    public ProcessInfoDocument getProcessInfo(QName qName) {
        return this.getProcessInfoCustom(qName, ProcessInfoCustomizer.ALL);
    }

    public ProcessInfoDocument activate(QName qName) {
        try {
            this._store.setState(qName, ProcessState.ACTIVE);
        }
        catch (Exception exception) {
            __log.error((Object)"Exception while setting process state", (Throwable)exception);
            throw new ManagementException("Error setting process state: " + exception.toString());
        }
        return this.genProcessInfoDocument(qName, ProcessInfoCustomizer.NONE);
    }

    public ProcessInfoDocument setRetired(QName qName, boolean bl) throws ManagementException {
        try {
            this._store.setState(qName, bl ? ProcessState.RETIRED : ProcessState.ACTIVE);
        }
        catch (BpelEngineException bpelEngineException) {
            __log.error((Object)"Exception while setting process as retired", (Throwable)bpelEngineException);
            throw new ProcessNotFoundException("ProcessNotFound:" + qName);
        }
        return this.genProcessInfoDocument(qName, ProcessInfoCustomizer.NONE);
    }

    public void setPackageRetired(String string, boolean bl) throws ManagementException {
        try {
            this._store.setRetiredPackage(string, bl);
        }
        catch (BpelEngineException bpelEngineException) {
            __log.error((Object)"Exception while setting process as retired", (Throwable)bpelEngineException);
            throw new ProcessNotFoundException("PackageNotFound:" + string);
        }
    }

    public ProcessInfoDocument setProcessPropertyNode(QName qName, QName qName2, Node node) throws ManagementException {
        ProcessInfoDocument processInfoDocument = ProcessInfoDocument.Factory.newInstance();
        TProcessInfo tProcessInfo = processInfoDocument.addNewProcessInfo();
        try {
            try {
                this._store.setProperty(qName, qName2, node);
            }
            catch (Exception exception) {
                __log.debug((Object)("Error setting property value for " + qName + "; " + qName2), (Throwable)exception);
            }
            ProcessConf processConf = this._store.getProcessConfiguration(qName);
            if (processConf == null) {
                throw new ProcessNotFoundException("ProcessNotFound:" + qName);
            }
            this.fillProcessInfo(tProcessInfo, processConf, new ProcessInfoCustomizer(new ProcessInfoCustomizer.Item[]{ProcessInfoCustomizer.Item.PROPERTIES}));
        }
        catch (ManagementException managementException) {
            throw managementException;
        }
        catch (Exception exception) {
            __log.error((Object)"Exception while setting process property", (Throwable)exception);
            throw new ProcessingException("Exception while setting process property: " + exception.toString());
        }
        return processInfoDocument;
    }

    public ProcessInfoDocument setProcessProperty(QName qName, QName qName2, String string) throws ManagementException {
        ProcessInfoDocument processInfoDocument = ProcessInfoDocument.Factory.newInstance();
        TProcessInfo tProcessInfo = processInfoDocument.addNewProcessInfo();
        try {
            try {
                this._store.setProperty(qName, qName2, string);
            }
            catch (Exception exception) {
                __log.debug((Object)("Error setting property value for " + qName + "; " + qName2), (Throwable)exception);
            }
            ProcessConf processConf = this._store.getProcessConfiguration(qName);
            if (processConf == null) {
                throw new ProcessNotFoundException("ProcessNotFound:" + qName);
            }
            this.fillProcessInfo(tProcessInfo, processConf, new ProcessInfoCustomizer(new ProcessInfoCustomizer.Item[]{ProcessInfoCustomizer.Item.PROPERTIES}));
        }
        catch (ManagementException managementException) {
            throw managementException;
        }
        catch (Exception exception) {
            __log.error((Object)"Exception while setting process property", (Throwable)exception);
            throw new ProcessingException("Exception while setting process property" + exception.toString());
        }
        return processInfoDocument;
    }

    public InstanceInfoListDocument listInstances(String string, String string2, int n) {
        InstanceInfoListDocument instanceInfoListDocument = InstanceInfoListDocument.Factory.newInstance();
        final TInstanceInfoList tInstanceInfoList = instanceInfoListDocument.addNewInstanceInfoList();
        final InstanceFilter instanceFilter = new InstanceFilter(string, string2, n);
        try {
            this._db.exec(new BpelDatabase.Callable<Object>(){

                @Override
                public Object run(BpelDAOConnection bpelDAOConnection) {
                    Collection collection = bpelDAOConnection.instanceQuery(instanceFilter);
                    for (ProcessInstanceDAO processInstanceDAO : collection) {
                        ProcessAndInstanceManagementImpl.this.fillInstanceInfo(tInstanceInfoList.addNewInstanceInfo(), processInstanceDAO);
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            __log.error((Object)"Exception while listing instances", (Throwable)exception);
            throw new ProcessingException("Exception while listing instances: " + exception.toString());
        }
        return instanceInfoListDocument;
    }

    public InstanceInfoListDocument listAllInstances() {
        return this.listInstances(null, null, Integer.MAX_VALUE);
    }

    public InstanceInfoListDocument listAllInstancesWithLimit(int n) {
        return this.listInstances(null, null, n);
    }

    public InstanceInfoDocument getInstanceInfo(Long l) throws InstanceNotFoundException {
        return this.genInstanceInfoDocument(l);
    }

    public ScopeInfoDocument getScopeInfo(String string) {
        return this.getScopeInfoWithActivity(string, false);
    }

    public ScopeInfoDocument getScopeInfoWithActivity(String string, boolean bl) {
        return this.genScopeInfoDocument(string, bl);
    }

    public VariableInfoDocument getVariableInfo(final String string, final String string2) throws ManagementException {
        VariableInfoDocument variableInfoDocument = VariableInfoDocument.Factory.newInstance();
        final TVariableInfo tVariableInfo = variableInfoDocument.addNewVariableInfo();
        final TVariableRef tVariableRef = tVariableInfo.addNewSelf();
        this.dbexec(new BpelDatabase.Callable<Object>(){

            @Override
            public Object run(BpelDAOConnection bpelDAOConnection) throws Exception {
                ScopeDAO scopeDAO = bpelDAOConnection.getScope(new Long(string));
                if (scopeDAO == null) {
                    throw new InvalidRequestException("ScopeNotFound:" + string);
                }
                tVariableRef.setSiid(string);
                tVariableRef.setIid(scopeDAO.getProcessInstance().getInstanceId().toString());
                tVariableRef.setName(string2);
                XmlDataDAO xmlDataDAO = scopeDAO.getVariable(string2);
                if (xmlDataDAO == null) {
                    throw new InvalidRequestException("VarNotFound:" + string2);
                }
                Node node = xmlDataDAO.get();
                if (node != null) {
                    TVariableInfo.Value value = tVariableInfo.addNewValue();
                    value.getDomNode().appendChild(value.getDomNode().getOwnerDocument().importNode(node, true));
                }
                return null;
            }
        });
        return variableInfoDocument;
    }

    public InstanceInfoDocument fault(Long l, QName qName, Element element) {
        return this.genInstanceInfoDocument(l);
    }

    public InstanceInfoDocument resume(Long l) {
        this.getDebugger(l).resume(l);
        return this.genInstanceInfoDocument(l);
    }

    public InstanceInfoDocument suspend(Long l) throws ManagementException {
        DebuggerSupport debuggerSupport = this.getDebugger(l);
        assert (debuggerSupport != null) : "getDebugger(Long) returned NULL!";
        debuggerSupport.suspend(l);
        return this.genInstanceInfoDocument(l);
    }

    public InstanceInfoDocument terminate(Long l) throws ManagementException {
        DebuggerSupport debuggerSupport = this.getDebugger(l);
        assert (debuggerSupport != null) : "getDebugger(Long) returned NULL!";
        debuggerSupport.terminate(l);
        return this.genInstanceInfoDocument(l);
    }

    public InstanceInfoDocument recoverActivity(final Long l, final Long l2, final String string) {
        try {
            this._db.exec(new BpelDatabase.Callable<QName>(){

                @Override
                public QName run(BpelDAOConnection bpelDAOConnection) throws Exception {
                    ProcessInstanceDAO processInstanceDAO = bpelDAOConnection.getInstance(l);
                    if (processInstanceDAO == null) {
                        return null;
                    }
                    for (ActivityRecoveryDAO activityRecoveryDAO : processInstanceDAO.getActivityRecoveries()) {
                        ODEProcess oDEProcess;
                        if (activityRecoveryDAO.getActivityId() != l2.longValue() || (oDEProcess = ProcessAndInstanceManagementImpl.this._server.getBpelProcess(processInstanceDAO.getProcess().getProcessId())) == null) continue;
                        oDEProcess.recoverActivity(processInstanceDAO, activityRecoveryDAO.getChannel(), l2, string, null);
                        break;
                    }
                    return processInstanceDAO.getProcess().getProcessId();
                }
            });
        }
        catch (Exception exception) {
            __log.error((Object)"Exception during activity recovery", (Throwable)exception);
            throw new ProcessingException("Exception during activity recovery" + exception.toString());
        }
        return this.genInstanceInfoDocument(l);
    }

    public Collection<Long> delete(String string) {
        final InstanceFilter instanceFilter = new InstanceFilter(string);
        final LinkedList<Long> linkedList = new LinkedList<Long>();
        try {
            this._db.exec(new BpelDatabase.Callable<Object>(){

                @Override
                public Object run(BpelDAOConnection bpelDAOConnection) {
                    Collection collection = bpelDAOConnection.instanceQuery(instanceFilter);
                    for (ProcessInstanceDAO processInstanceDAO : collection) {
                        processInstanceDAO.delete();
                        linkedList.add(processInstanceDAO.getInstanceId());
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            __log.error((Object)"Exception during instance deletion", (Throwable)exception);
            throw new ProcessingException("Exception during instance deletion: " + exception.toString());
        }
        return linkedList;
    }

    public List<String> getEventTimeline(String string, String string2) {
        final InstanceFilter instanceFilter = new InstanceFilter(string, null, 0);
        final BpelEventFilter bpelEventFilter = new BpelEventFilter(string2, 0);
        List<Date> list = this.dbexec(new BpelDatabase.Callable<List<Date>>(){

            @Override
            public List<Date> run(BpelDAOConnection bpelDAOConnection) throws Exception {
                return bpelDAOConnection.bpelEventTimelineQuery(instanceFilter, bpelEventFilter);
            }
        });
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        CollectionsX.transform(arrayList, list, (UnaryFunction)new UnaryFunction<Date, String>(){

            public String apply(Date date) {
                return ISO8601DateParser.format((Date)date);
            }
        });
        return arrayList;
    }

    public EventInfoListDocument listEvents(String string, String string2, int n) {
        final InstanceFilter instanceFilter = new InstanceFilter(string, null, 0);
        final BpelEventFilter bpelEventFilter = new BpelEventFilter(string2, n);
        EventInfoListDocument eventInfoListDocument = EventInfoListDocument.Factory.newInstance();
        final TEventInfoList tEventInfoList = eventInfoListDocument.addNewEventInfoList();
        this.dbexec(new BpelDatabase.Callable<Object>(){

            @Override
            public Object run(BpelDAOConnection bpelDAOConnection) throws Exception {
                List list = bpelDAOConnection.bpelEventQuery(instanceFilter, bpelEventFilter);
                for (BpelEvent bpelEvent : list) {
                    TEventInfo tEventInfo = tEventInfoList.addNewEventInfo();
                    ProcessAndInstanceManagementImpl.this.fillEventInfo(tEventInfo, bpelEvent);
                }
                return null;
            }
        });
        return eventInfoListDocument;
    }

    public ActivityExtInfoListDocument getExtensibilityElements(QName qName, Integer[] integerArray) {
        ActivityExtInfoListDocument activityExtInfoListDocument = ActivityExtInfoListDocument.Factory.newInstance();
        TActivitytExtInfoList tActivitytExtInfoList = activityExtInfoListDocument.addNewActivityExtInfoList();
        ProcessModel processModel = this._server.getProcessModel(qName);
        if (processModel == null) {
            throw new ProcessNotFoundException("The process \"" + qName + "\" does not exist.");
        }
        Integer[] integerArray2 = integerArray;
        int n = integerArray2.length;
        for (int i = 0; i < n; ++i) {
            int n2 = integerArray2[i];
            ActivityModel activityModel = processModel.getChild(n2);
            if (activityModel == null || activityModel.getExtensibilityElements() == null) continue;
            for (Map.Entry entry : activityModel.getExtensibilityElements().entrySet()) {
                TActivityExtInfo tActivityExtInfo = tActivitytExtInfoList.addNewActivityExtInfo();
                tActivityExtInfo.setAiid("" + n2);
                Object v = entry.getValue();
                if (v instanceof Element) {
                    tActivityExtInfo.getDomNode().appendChild(tActivityExtInfo.getDomNode().getOwnerDocument().importNode((Element)v, true));
                    continue;
                }
                if (!(v instanceof String)) continue;
                Element element = tActivityExtInfo.getDomNode().getOwnerDocument().createElementNS(((QName)entry.getKey()).getNamespaceURI(), ((QName)entry.getKey()).getLocalPart());
                element.appendChild(tActivityExtInfo.getDomNode().getOwnerDocument().createTextNode((String)v));
                tActivityExtInfo.getDomNode().appendChild(element);
            }
        }
        return activityExtInfoListDocument;
    }

    protected final DebuggerSupport getDebugger(QName qName) throws ManagementException {
        ODEProcess oDEProcess = this._server.getBpelProcess(qName);
        if (oDEProcess == null) {
            throw new ProcessNotFoundException("The process \"" + qName + "\" does not exist.");
        }
        return oDEProcess._debugger;
    }

    protected final DebuggerSupport getDebugger(final Long l) {
        QName qName;
        try {
            qName = this._db.exec(new BpelDatabase.Callable<QName>(){

                @Override
                public QName run(BpelDAOConnection bpelDAOConnection) throws Exception {
                    ProcessInstanceDAO processInstanceDAO = bpelDAOConnection.getInstance(l);
                    return processInstanceDAO == null ? null : processInstanceDAO.getProcess().getProcessId();
                }
            });
        }
        catch (Exception exception) {
            __log.error((Object)"Exception during instance retrieval", (Throwable)exception);
            throw new ProcessingException("Exception during instance retrieval: " + exception.toString());
        }
        return this.getDebugger(qName);
    }

    protected <T> T dbexec(BpelProcessDatabase.Callable<T> callable) throws ManagementException {
        try {
            return callable.exec();
        }
        catch (ManagementException managementException) {
            throw managementException;
        }
        catch (Exception exception) {
            __log.error((Object)"Exception during database operation", (Throwable)exception);
            throw new ManagementException("Exception during database operation: " + exception.toString());
        }
    }

    protected <T> T dbexec(BpelDatabase.Callable<T> callable) throws ManagementException {
        try {
            return this._db.exec(callable);
        }
        catch (ManagementException managementException) {
            throw managementException;
        }
        catch (Exception exception) {
            __log.error((Object)"Exception during database operation", (Throwable)exception);
            throw new ManagementException("Exception during database operation" + exception.toString());
        }
    }

    private ProcessInfoDocument genProcessInfoDocument(QName qName, ProcessInfoCustomizer processInfoCustomizer) throws ManagementException {
        if (qName == null) {
            throw new InvalidRequestException("Valid QName as process id expected.");
        }
        ProcessInfoDocument processInfoDocument = ProcessInfoDocument.Factory.newInstance();
        TProcessInfo tProcessInfo = processInfoDocument.addNewProcessInfo();
        try {
            ProcessConf processConf = this._store.getProcessConfiguration(qName);
            if (processConf == null) {
                throw new ProcessNotFoundException("ProcessNotFound:" + qName);
            }
            this.fillProcessInfo(tProcessInfo, processConf, processInfoCustomizer);
        }
        catch (ManagementException managementException) {
            throw managementException;
        }
        catch (Exception exception) {
            __log.error((Object)"Exception while retrieving process information", (Throwable)exception);
            throw new ProcessingException("Exception while retrieving process information: " + exception.toString());
        }
        return processInfoDocument;
    }

    private InstanceInfoDocument genInstanceInfoDocument(final Long l) {
        if (l == null) {
            throw new InvalidRequestException("Must specifiy instance id.");
        }
        InstanceInfoDocument instanceInfoDocument = InstanceInfoDocument.Factory.newInstance();
        final TInstanceInfo tInstanceInfo = instanceInfoDocument.addNewInstanceInfo();
        tInstanceInfo.setIid(l.toString());
        this.dbexec(new BpelDatabase.Callable<Object>(){

            @Override
            public Object run(BpelDAOConnection bpelDAOConnection) throws Exception {
                ProcessInstanceDAO processInstanceDAO = bpelDAOConnection.getInstance(l);
                if (processInstanceDAO == null) {
                    throw new InstanceNotFoundException("" + l);
                }
                ProcessAndInstanceManagementImpl.this.fillInstanceInfo(tInstanceInfo, processInstanceDAO);
                return null;
            }
        });
        return instanceInfoDocument;
    }

    private ScopeInfoDocument genScopeInfoDocument(String string, final boolean bl) {
        Long l;
        if (string == null) {
            throw new InvalidRequestException("Must specifiy scope instance id.");
        }
        try {
            l = new Long(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException("Invalid scope instance id.");
        }
        ScopeInfoDocument scopeInfoDocument = ScopeInfoDocument.Factory.newInstance();
        final TScopeInfo tScopeInfo = scopeInfoDocument.addNewScopeInfo();
        tScopeInfo.setSiid(string);
        this.dbexec(new BpelDatabase.Callable<Object>(){

            @Override
            public Object run(BpelDAOConnection bpelDAOConnection) throws Exception {
                try {
                    ScopeDAO scopeDAO = bpelDAOConnection.getScope(l);
                    if (scopeDAO == null) {
                        throw new InvalidRequestException("Scope not found: " + l);
                    }
                    ProcessAndInstanceManagementImpl.this.fillScopeInfo(tScopeInfo, scopeDAO, bl);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return null;
            }
        });
        return scopeInfoDocument;
    }

    private void fillProcessInfo(TProcessInfo tProcessInfo, ProcessConf processConf, ProcessInfoCustomizer processInfoCustomizer) {
        Node node;
        Document document;
        TInstanceSummary tInstanceSummary;
        if (processConf == null) {
            throw new IllegalArgumentException("Null pconf.");
        }
        tProcessInfo.setPid(processConf.getProcessId().toString());
        if (processConf.getState() == ProcessState.RETIRED) {
            tProcessInfo.setStatus(TProcessStatus.RETIRED);
        } else {
            tProcessInfo.setStatus(TProcessStatus.ACTIVE);
        }
        tProcessInfo.setVersion(processConf.getVersion());
        TDefinitionInfo tDefinitionInfo = tProcessInfo.addNewDefinitionInfo();
        tDefinitionInfo.setProcessName(processConf.getType());
        TDeploymentInfo tDeploymentInfo = tProcessInfo.addNewDeploymentInfo();
        tDeploymentInfo.setPackage(processConf.getPackage());
        tDeploymentInfo.setDocument(processConf.getBpelDocument());
        tDeploymentInfo.setDeployDate(this.toCalendar(processConf.getDeployDate()));
        if (processInfoCustomizer.includeInstanceSummary()) {
            tInstanceSummary = tProcessInfo.addNewInstanceSummary();
            this.genInstanceSummaryEntry(tInstanceSummary.addNewInstances(), TInstanceStatus.ACTIVE, processConf);
            this.genInstanceSummaryEntry(tInstanceSummary.addNewInstances(), TInstanceStatus.COMPLETED, processConf);
            this.genInstanceSummaryEntry(tInstanceSummary.addNewInstances(), TInstanceStatus.ERROR, processConf);
            this.genInstanceSummaryEntry(tInstanceSummary.addNewInstances(), TInstanceStatus.FAILED, processConf);
            this.genInstanceSummaryEntry(tInstanceSummary.addNewInstances(), TInstanceStatus.SUSPENDED, processConf);
            this.genInstanceSummaryEntry(tInstanceSummary.addNewInstances(), TInstanceStatus.TERMINATED, processConf);
            this.getInstanceSummaryActivityFailure(tInstanceSummary, processConf);
        }
        tInstanceSummary = tProcessInfo.addNewDocuments();
        List list = processConf.getFiles();
        if (list != null) {
            this.genDocumentInfo((TProcessInfo.Documents)tInstanceSummary, list.toArray(new File[list.size()]), true);
        } else if (__log.isDebugEnabled()) {
            __log.debug((Object)("fillProcessInfo: No files for " + processConf.getProcessId()));
        }
        TProcessProperties tProcessProperties = tProcessInfo.addNewProperties();
        if (processInfoCustomizer.includeProcessProperties()) {
            for (Map.Entry object2 : processConf.getProcessProperties().entrySet()) {
                TProcessProperties.Property property = tProcessProperties.addNewProperty();
                property.setName(new QName(((QName)object2.getKey()).getNamespaceURI(), ((QName)object2.getKey()).getLocalPart()));
                Object object = property.getDomNode();
                document = object.getOwnerDocument();
                node = document.importNode((Node)object2.getValue(), true);
                object.appendChild(node);
            }
        }
        TEndpointReferences tEndpointReferences = tProcessInfo.addNewEndpoints();
        ProcessModel processModel = this._server.getProcessModel(processConf.getProcessId());
        if (processInfoCustomizer.includeEndpoints() && processModel != null) {
            for (Object object : processModel.getAllPartnerLinks()) {
                if (!object.hasPartnerRole() || !object.isInitializePartnerRoleSet() || (document = this._server.getBpelProcess(processConf.getProcessId()).getInitialPartnerRoleEPR((PartnerLinkModel)object)) == null) continue;
                node = tEndpointReferences.addNewEndpointRef();
                Document document2 = node.getDomNode().getOwnerDocument();
                node.getDomNode().appendChild(document2.importNode(document.toXML().getDocumentElement(), true));
            }
        }
    }

    private void genDocumentInfo(TProcessInfo.Documents documents, File[] fileArray, boolean bl) {
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            if (file.isHidden()) continue;
            if (file.isDirectory()) {
                if (!bl) continue;
                this.genDocumentInfo(documents, file.listFiles(), true);
                continue;
            }
            if (!file.isFile()) continue;
            this.genDocumentInfo(documents, file);
        }
    }

    private void genDocumentInfo(TProcessInfo.Documents documents, File file) {
        DocumentInfoGenerator documentInfoGenerator = new DocumentInfoGenerator(file);
        if (documentInfoGenerator.isRecognized() && documentInfoGenerator.isVisible()) {
            TDocumentInfo tDocumentInfo = documents.addNewDocument();
            tDocumentInfo.setName(documentInfoGenerator.getName());
            tDocumentInfo.setSource(documentInfoGenerator.getURL());
            tDocumentInfo.setType(documentInfoGenerator.getType());
        }
    }

    private void genInstanceSummaryEntry(TInstanceSummary.Instances instances, TInstanceStatus.Enum enum_, ProcessConf processConf) {
        instances.setState(enum_);
        String string = InstanceFilter.StatusKeys.valueOf((String)enum_.toString()).toString().toLowerCase();
        final InstanceFilter instanceFilter = new InstanceFilter("status=" + string + " pid=" + processConf.getProcessId());
        int n = this.dbexec(new BpelDatabase.Callable<Integer>(){

            @Override
            public Integer run(BpelDAOConnection bpelDAOConnection) throws Exception {
                return bpelDAOConnection.instanceQuery(instanceFilter).size();
            }
        });
        instances.setCount(n);
    }

    private void getInstanceSummaryActivityFailure(final TInstanceSummary tInstanceSummary, ProcessConf processConf) {
        String string = InstanceFilter.StatusKeys.valueOf((String)TInstanceStatus.ACTIVE.toString()).toString().toLowerCase();
        final InstanceFilter instanceFilter = new InstanceFilter("status=" + string + " pid=" + processConf.getProcessId());
        this.dbexec(new BpelDatabase.Callable<Void>(){

            @Override
            public Void run(BpelDAOConnection bpelDAOConnection) throws Exception {
                Date date = null;
                int n = 0;
                for (ProcessInstanceDAO processInstanceDAO : bpelDAOConnection.instanceQuery(instanceFilter)) {
                    int n2 = processInstanceDAO.getActivityFailureCount();
                    if (n2 <= 0) continue;
                    ++n;
                    Date date2 = processInstanceDAO.getActivityFailureDateTime();
                    if (date != null && !date.before(date2)) continue;
                    date = date2;
                }
                if (n > 0) {
                    TFailuresInfo tFailuresInfo = tInstanceSummary.addNewFailures();
                    tFailuresInfo.setDtFailure(ProcessAndInstanceManagementImpl.this.toCalendar(date));
                    tFailuresInfo.setCount(n);
                }
                return null;
            }
        });
    }

    private void fillInstanceInfo(TInstanceInfo tInstanceInfo, ProcessInstanceDAO processInstanceDAO) {
        TInstanceInfo.CorrelationProperties correlationProperties;
        TFaultInfo tFaultInfo;
        tInstanceInfo.setIid("" + processInstanceDAO.getInstanceId());
        ProcessDAO processDAO = processInstanceDAO.getProcess();
        tInstanceInfo.setPid(processDAO.getProcessId().toString());
        tInstanceInfo.setProcessName(processDAO.getType());
        if (processInstanceDAO.getRootScope() != null) {
            tInstanceInfo.setRootScope(this.genScopeRef(processInstanceDAO.getRootScope()));
        }
        tInstanceInfo.setDtStarted(this.toCalendar(processInstanceDAO.getCreateTime()));
        tInstanceInfo.setDtLastActive(this.toCalendar(processInstanceDAO.getLastActiveTime()));
        tInstanceInfo.setStatus(__psc.cvtInstanceStatus(processInstanceDAO.getState()));
        if (processInstanceDAO.getFault() != null) {
            tFaultInfo = tInstanceInfo.addNewFaultInfo();
            tFaultInfo.setName(processInstanceDAO.getFault().getName());
            tFaultInfo.setExplanation(processInstanceDAO.getFault().getExplanation());
            tFaultInfo.setAiid(processInstanceDAO.getFault().getActivityId());
            tFaultInfo.setLineNumber(processInstanceDAO.getFault().getLineNo());
        }
        tFaultInfo = processInstanceDAO.getEventsFirstLastCount();
        TInstanceInfo.EventInfo eventInfo = tInstanceInfo.addNewEventInfo();
        if (!processInstanceDAO.getCorrelationSets().isEmpty()) {
            correlationProperties = tInstanceInfo.addNewCorrelationProperties();
            for (CorrelationSetDAO correlationSetDAO : processInstanceDAO.getCorrelationSets()) {
                for (Map.Entry entry : correlationSetDAO.getProperties().entrySet()) {
                    TCorrelationProperty tCorrelationProperty = correlationProperties.addNewCorrelationProperty();
                    tCorrelationProperty.setCsetid("" + correlationSetDAO.getCorrelationSetId());
                    tCorrelationProperty.setPropertyName((QName)entry.getKey());
                    tCorrelationProperty.setStringValue((String)entry.getValue());
                }
            }
        }
        if (tFaultInfo != null) {
            eventInfo.setFirstDtime(this.toCalendar(tFaultInfo.first));
            eventInfo.setLastDtime(this.toCalendar(tFaultInfo.last));
            eventInfo.setCount(tFaultInfo.count);
        }
        if (processInstanceDAO.getActivityFailureCount() > 0) {
            correlationProperties = tInstanceInfo.addNewFailures();
            correlationProperties.setDtFailure(this.toCalendar(processInstanceDAO.getActivityFailureDateTime()));
            correlationProperties.setCount(processInstanceDAO.getActivityFailureCount());
        }
    }

    private void fillScopeInfo(TScopeInfo tScopeInfo, ScopeDAO scopeDAO, boolean bl) {
        Iterator<Object> iterator;
        TCorrelationProperty tCorrelationProperty;
        ActivityStateDocumentBuilder activityStateDocumentBuilder;
        Object object222;
        Object object3;
        Object object422;
        tScopeInfo.setSiid("" + scopeDAO.getScopeInstanceId());
        tScopeInfo.setName(scopeDAO.getName());
        if (scopeDAO.getParentScope() != null) {
            tScopeInfo.setParentScopeRef(this.genScopeRef(scopeDAO.getParentScope()));
        }
        tScopeInfo.setStatus(__psc.cvtScopeStatus(scopeDAO.getState()));
        TScopeInfo.Children children = tScopeInfo.addNewChildren();
        for (Object object422 : scopeDAO.getChildScopes()) {
            this.fillScopeRef(children.addNewChildRef(), (ScopeDAO)object422);
        }
        TScopeInfo.Variables variables = tScopeInfo.addNewVariables();
        object422 = scopeDAO.getVariables().iterator();
        while (object422.hasNext()) {
            object3 = (XmlDataDAO)object422.next();
            this.fillVariableRef(variables.addNewVariableRef(), (XmlDataDAO)object3);
        }
        if (!scopeDAO.getCorrelationSets().isEmpty()) {
            object422 = tScopeInfo.addNewCorrelationSets();
            for (Object object222 : scopeDAO.getCorrelationSets()) {
                activityStateDocumentBuilder = object422.addNewCorrelationSet();
                activityStateDocumentBuilder.setCsetid("" + object222.getCorrelationSetId());
                activityStateDocumentBuilder.setName(object222.getName());
                for (Map.Entry object5 : object222.getProperties().entrySet()) {
                    tCorrelationProperty = activityStateDocumentBuilder.addNewCorrelationProperty();
                    tCorrelationProperty.setCsetid("" + object222.getCorrelationSetId());
                    tCorrelationProperty.setPropertyName((QName)object5.getKey());
                    tCorrelationProperty.setStringValue((String)object5.getValue());
                }
            }
        }
        if (bl) {
            object422 = scopeDAO.getProcessInstance().getActivityRecoveries();
            object3 = tScopeInfo.addNewActivities();
            object222 = scopeDAO.listEvents();
            activityStateDocumentBuilder = new ActivityStateDocumentBuilder();
            iterator = object222.iterator();
            while (iterator.hasNext()) {
                BpelEvent bpelEvent = (BpelEvent)iterator.next();
                activityStateDocumentBuilder.onEvent(bpelEvent);
            }
            for (ActivityInfoDocument activityInfoDocument : activityStateDocumentBuilder.getActivities()) {
                tCorrelationProperty = object422.iterator();
                while (tCorrelationProperty.hasNext()) {
                    ActivityRecoveryDAO activityRecoveryDAO = (ActivityRecoveryDAO)tCorrelationProperty.next();
                    if (!String.valueOf(activityRecoveryDAO.getActivityId()).equals(activityInfoDocument.getActivityInfo().getAiid())) continue;
                    TFailureInfo tFailureInfo = activityInfoDocument.getActivityInfo().addNewFailure();
                    tFailureInfo.setReason(activityRecoveryDAO.getReason());
                    tFailureInfo.setDtFailure(this.toCalendar(activityRecoveryDAO.getDateTime()));
                    tFailureInfo.setActions(activityRecoveryDAO.getActions());
                    tFailureInfo.setRetries(activityRecoveryDAO.getRetries());
                    activityInfoDocument.getActivityInfo().setStatus(TActivityStatus.FAILURE);
                }
                object3.addNewActivityInfo().set((XmlObject)activityInfoDocument.getActivityInfo());
            }
        }
        if ((object422 = scopeDAO.getPartnerLinks()).size() > 0) {
            object3 = tScopeInfo.addNewEndpoints();
            object222 = object422.iterator();
            while (object222.hasNext()) {
                activityStateDocumentBuilder = (PartnerLinkDAO)object222.next();
                if (activityStateDocumentBuilder.getPartnerRoleName() == null || activityStateDocumentBuilder.getPartnerRoleName().length() <= 0) continue;
                iterator = object3.addNewEndpointRef();
                iterator.setPartnerLink(activityStateDocumentBuilder.getPartnerLinkName());
                iterator.setPartnerRole(activityStateDocumentBuilder.getPartnerRoleName());
                if (activityStateDocumentBuilder.getPartnerEPR() == null) continue;
                Document document = iterator.getDomNode().getOwnerDocument();
                iterator.getDomNode().appendChild(document.importNode(activityStateDocumentBuilder.getPartnerEPR(), true));
            }
        }
    }

    private void fillVariableRef(TVariableRef tVariableRef, XmlDataDAO xmlDataDAO) {
        tVariableRef.setIid(xmlDataDAO.getScopeDAO().getProcessInstance().getInstanceId().toString());
        tVariableRef.setSiid(xmlDataDAO.getScopeDAO().getScopeInstanceId().toString());
        tVariableRef.setName(xmlDataDAO.getName());
    }

    private TScopeRef genScopeRef(ScopeDAO scopeDAO) {
        TScopeRef tScopeRef = TScopeRef.Factory.newInstance();
        this.fillScopeRef(tScopeRef, scopeDAO);
        return tScopeRef;
    }

    private void fillScopeRef(TScopeRef tScopeRef, ScopeDAO scopeDAO) {
        tScopeRef.setSiid(scopeDAO.getScopeInstanceId().toString());
        tScopeRef.setStatus(__psc.cvtScopeStatus(scopeDAO.getState()));
        tScopeRef.setName(scopeDAO.getName());
        tScopeRef.setModelId("" + scopeDAO.getModelId());
    }

    private void fillEventInfo(TEventInfo tEventInfo, BpelEvent bpelEvent) {
        tEventInfo.setName(BpelEvent.eventName((BpelEvent)bpelEvent));
        tEventInfo.setType(bpelEvent.getType().toString());
        tEventInfo.setLineNumber(bpelEvent.getLineNo());
        tEventInfo.setTimestamp(this.toCalendar(bpelEvent.getTimestamp()));
        if (bpelEvent instanceof ActivityEvent) {
            tEventInfo.setActivityName(((ActivityEvent)bpelEvent).getActivityName());
            tEventInfo.setActivityId(((ActivityEvent)bpelEvent).getActivityId());
            tEventInfo.setActivityType(((ActivityEvent)bpelEvent).getActivityType());
            tEventInfo.setActivityDefinitionId(((ActivityEvent)bpelEvent).getActivityDeclarationId());
        }
        if (bpelEvent instanceof CorrelationEvent) {
            tEventInfo.setPortType(((CorrelationEvent)bpelEvent).getPortType());
            tEventInfo.setOperation(((CorrelationEvent)bpelEvent).getOperation());
            tEventInfo.setMexId(((CorrelationEvent)bpelEvent).getMessageExchangeId());
        }
        if (bpelEvent instanceof CorrelationMatchEvent) {
            tEventInfo.setPortType(((CorrelationMatchEvent)bpelEvent).getPortType());
        }
        if (bpelEvent instanceof CorrelationSetEvent) {
            tEventInfo.setCorrelationSet(((CorrelationSetEvent)bpelEvent).getCorrelationSetName());
        }
        if (bpelEvent instanceof CorrelationSetWriteEvent) {
            tEventInfo.setCorrelationKey(((CorrelationSetWriteEvent)bpelEvent).getCorrelationSetName());
        }
        if (bpelEvent instanceof ExpressionEvaluationEvent) {
            tEventInfo.setExpression(((ExpressionEvaluationEvent)bpelEvent).getExpression());
        }
        if (bpelEvent instanceof ExpressionEvaluationFailedEvent) {
            tEventInfo.setFault(((ExpressionEvaluationFailedEvent)bpelEvent).getFault());
        }
        if (bpelEvent instanceof NewProcessInstanceEvent) {
            if (((NewProcessInstanceEvent)bpelEvent).getRootScopeId() != null) {
                tEventInfo.setRootScopeId(((NewProcessInstanceEvent)bpelEvent).getRootScopeId().longValue());
            }
            tEventInfo.setScopeDefinitionId(((NewProcessInstanceEvent)bpelEvent).getScopeDeclarationId());
        }
        if (bpelEvent instanceof PartnerLinkEvent) {
            tEventInfo.setPartnerLinkName(((PartnerLinkEvent)bpelEvent).getpLinkName());
        }
        if (bpelEvent instanceof ProcessCompletionEvent) {
            tEventInfo.setFault(((ProcessCompletionEvent)bpelEvent).getFault());
        }
        if (bpelEvent instanceof ProcessEvent) {
            tEventInfo.setProcessId(((ProcessEvent)bpelEvent).getProcessId());
            tEventInfo.setProcessType(((ProcessEvent)bpelEvent).getProcessName());
        }
        if (bpelEvent instanceof ProcessInstanceEvent) {
            tEventInfo.setInstanceId(((ProcessInstanceEvent)bpelEvent).getProcessInstanceId().longValue());
        }
        if (bpelEvent instanceof ProcessInstanceStartedEvent) {
            tEventInfo.setRootScopeId(((ProcessInstanceStartedEvent)bpelEvent).getRootScopeId().longValue());
            tEventInfo.setRootScopeDeclarationId(((ProcessInstanceStartedEvent)bpelEvent).getScopeDeclarationId());
        }
        if (bpelEvent instanceof ProcessInstanceStateChangeEvent) {
            tEventInfo.setOldState((int)((ProcessInstanceStateChangeEvent)bpelEvent).getOldState());
            tEventInfo.setNewState((int)((ProcessInstanceStateChangeEvent)bpelEvent).getNewState());
        }
        if (bpelEvent instanceof ProcessMessageExchangeEvent) {
            tEventInfo.setPortType(((ProcessMessageExchangeEvent)bpelEvent).getPortType());
            tEventInfo.setOperation(((ProcessMessageExchangeEvent)bpelEvent).getOperation());
            tEventInfo.setMexId(((ProcessMessageExchangeEvent)bpelEvent).getMessageExchangeId());
        }
        if (bpelEvent instanceof ScopeCompletionEvent) {
            tEventInfo.setSuccess(((ScopeCompletionEvent)bpelEvent).isSuccess());
            tEventInfo.setFault(((ScopeCompletionEvent)bpelEvent).getFault());
        }
        if (bpelEvent instanceof ScopeEvent) {
            tEventInfo.setScopeId(((ScopeEvent)bpelEvent).getScopeId().longValue());
            if (((ScopeEvent)bpelEvent).getParentScopeId() != null) {
                tEventInfo.setParentScopeId(((ScopeEvent)bpelEvent).getParentScopeId().longValue());
            }
            if (((ScopeEvent)bpelEvent).getScopeName() != null) {
                tEventInfo.setScopeName(((ScopeEvent)bpelEvent).getScopeName());
            }
            tEventInfo.setScopeDefinitionId(((ScopeEvent)bpelEvent).getScopeDeclarationId());
        }
        if (bpelEvent instanceof ScopeFaultEvent) {
            tEventInfo.setFault(((ScopeFaultEvent)bpelEvent).getFaultType());
            tEventInfo.setFaultLineNumber(((ScopeFaultEvent)bpelEvent).getFaultLineNo());
            tEventInfo.setExplanation(((ScopeFaultEvent)bpelEvent).getExplanation());
        }
        if (bpelEvent instanceof VariableEvent) {
            tEventInfo.setVariableName(((VariableEvent)bpelEvent).getVarName());
        }
    }

    private Calendar toCalendar(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = (Calendar)this._calendar.clone();
        calendar.setTime(date);
        return calendar;
    }

    public InstanceInfoListDocument queryInstances(final String string) {
        InstanceInfoListDocument instanceInfoListDocument = InstanceInfoListDocument.Factory.newInstance();
        final TInstanceInfoList tInstanceInfoList = instanceInfoListDocument.addNewInstanceInfoList();
        try {
            this._db.exec(new BpelDatabase.Callable<Object>(){

                @Override
                public Object run(BpelDAOConnection bpelDAOConnection) {
                    Collection collection = bpelDAOConnection.instanceQuery(string);
                    for (ProcessInstanceDAO processInstanceDAO : collection) {
                        ProcessAndInstanceManagementImpl.this.fillInstanceInfo(tInstanceInfoList.addNewInstanceInfo(), processInstanceDAO);
                    }
                    return null;
                }
            });
        }
        catch (Exception exception) {
            __log.error((Object)"Exception while querying instances", (Throwable)exception);
            throw new ProcessingException("Exception while querying instances: " + exception.toString());
        }
        return instanceInfoListDocument;
    }

    Collection<ProcessConf> processQuery(ProcessFilter processFilter) {
        Object object2;
        Serializable serializable;
        List list = this._store.getProcesses();
        if (processFilter != null && processFilter.getNameFilter() != null) {
            serializable = Pattern.compile(processFilter.getNameFilter().replace("*", ".*") + "(-\\d*)?");
            CollectionsX.remove_if((Collection)list, (MemberOfFunction)new MemberOfFunction<QName>(){

                public boolean isMember(QName qName) {
                    return !serializable.matcher(qName.getLocalPart()).matches();
                }
            });
        }
        if (processFilter != null && processFilter.getNamespaceFilter() != null) {
            serializable = Pattern.compile(processFilter.getNamespaceFilter().replace("*", ".*"));
            CollectionsX.remove_if((Collection)list, (MemberOfFunction)new MemberOfFunction<QName>(){

                public boolean isMember(QName qName) {
                    String string = qName.getNamespaceURI() == null ? "" : qName.getNamespaceURI();
                    return !serializable.matcher(string).matches();
                }
            });
        }
        serializable = new LinkedList();
        for (final Iterator iterator : list) {
            object2 = this._store.getProcessConfiguration((QName)((Object)iterator));
            serializable.add(object2);
        }
        if (processFilter != null) {
            if (processFilter.getDeployedDateFilter() != null) {
                for (final Iterator iterator : processFilter.getDeployedDateFilter()) {
                    try {
                        object2 = ISO8601DateParser.parse((String)Filter.getDateWithoutOp(iterator));
                    }
                    catch (ParseException parseException) {
                        __log.error((Object)"Exception while parsing date", (Throwable)parseException);
                        throw new RuntimeException(parseException.toString());
                    }
                    CollectionsX.remove_if((Collection)((Object)serializable), (MemberOfFunction)new MemberOfFunction<ProcessConf>((Date)object2){
                        final /* synthetic */ Date val$dd;
                        {
                            this.val$dd = date;
                        }

                        public boolean isMember(ProcessConf processConf) {
                            if (iterator.startsWith("=")) {
                                return !processConf.getDeployDate().equals(this.val$dd);
                            }
                            if (iterator.startsWith("<=")) {
                                return processConf.getDeployDate().getTime() > this.val$dd.getTime();
                            }
                            if (iterator.startsWith(">=")) {
                                return processConf.getDeployDate().getTime() < this.val$dd.getTime();
                            }
                            if (iterator.startsWith("<")) {
                                return processConf.getDeployDate().getTime() >= this.val$dd.getTime();
                            }
                            if (iterator.startsWith(">")) {
                                return processConf.getDeployDate().getTime() <= this.val$dd.getTime();
                            }
                            return false;
                        }
                    });
                }
            }
            if (processFilter.getOrders() != null) {
                ComparatorChain comparatorChain = new ComparatorChain();
                for (Object object2 : processFilter.getOrders()) {
                    Comparator<ProcessConf> comparator;
                    boolean bl = true;
                    Object object3 = object2;
                    if (((String)object2).startsWith("+") || ((String)object2).startsWith("-")) {
                        object3 = ((String)object2).substring(1, ((String)object2).length());
                        if (((String)object2).startsWith("-")) {
                            bl = false;
                        }
                    }
                    if ("name".equals(object3)) {
                        comparator = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf processConf, ProcessConf processConf2) {
                                return processConf.getProcessId().getLocalPart().compareTo(processConf2.getProcessId().getLocalPart());
                            }
                        };
                    } else if ("namespace".equals(object3)) {
                        comparator = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf processConf, ProcessConf processConf2) {
                                String string = processConf.getProcessId().getNamespaceURI() == null ? "" : processConf.getProcessId().getNamespaceURI();
                                String string2 = processConf2.getProcessId().getNamespaceURI() == null ? "" : processConf2.getProcessId().getNamespaceURI();
                                return string.compareTo(string2);
                            }
                        };
                    } else if ("version".equals(object3)) {
                        comparator = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf processConf, ProcessConf processConf2) {
                                return (int)(processConf.getVersion() - processConf2.getVersion());
                            }
                        };
                    } else if ("deployed".equals(object3)) {
                        comparator = new Comparator<ProcessConf>(){

                            @Override
                            public int compare(ProcessConf processConf, ProcessConf processConf2) {
                                return processConf.getDeployDate().compareTo(processConf2.getDeployDate());
                            }
                        };
                    } else {
                        __log.debug((Object)("unrecognized order key" + (String)object3));
                        continue;
                    }
                    comparatorChain.addComparator((Comparator)comparator, !bl);
                }
                Collections.sort(serializable, comparatorChain);
            }
        }
        return serializable;
    }
}

