/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.file.internal;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.FileFileFilter;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.ImportingException;
import org.eclipse.smila.importing.crawler.file.FileCrawlerService;
import org.eclipse.smila.importing.crawler.file.internal.FileToRecordConverter;
import org.eclipse.smila.importing.util.PropertyNameMapper;
import org.eclipse.smila.taskworker.TaskContext;

public class FileCrawlerServiceImpl
implements FileCrawlerService {
    private final Set<String> _filePropertyNames = new HashSet<String>();

    public FileCrawlerServiceImpl() {
        this._filePropertyNames.add("fileName");
        this._filePropertyNames.add("filePath");
        this._filePropertyNames.add("fileFolder");
        this._filePropertyNames.add("fileSize");
        this._filePropertyNames.add("fileLastModified");
        this._filePropertyNames.add("fileExtension");
        this._filePropertyNames.add("fileContent");
    }

    @Override
    public Collection<File> listFiles(File directory) {
        File[] fileList = directory.listFiles((FileFilter)FileFileFilter.FILE);
        if (fileList != null) {
            return Arrays.asList(fileList);
        }
        return new ArrayList<File>();
    }

    @Override
    public Collection<File> listDirectories(File directory) {
        File[] fileList = directory.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        if (fileList != null) {
            return Arrays.asList(fileList);
        }
        return new ArrayList<File>();
    }

    @Override
    public Collection<File> list(File directory) {
        File[] fileList = directory.listFiles();
        if (fileList != null) {
            return Arrays.asList(fileList);
        }
        return new ArrayList<File>();
    }

    @Override
    public Record fileToRecord(File file, String dataSource, boolean withContent) throws IOException {
        FileToRecordConverter converter = new FileToRecordConverter(DataFactory.DEFAULT);
        return converter.fileToRecord(file, dataSource, withContent);
    }

    @Override
    public void addAttachment(Record record, String pathAttribute, String attachmentName) throws IOException {
        FileToRecordConverter converter = new FileToRecordConverter(DataFactory.DEFAULT);
        converter.addAttachment(record, pathAttribute, attachmentName);
    }

    @Override
    public Record dirToRecord(File directory, String dataSource) {
        FileToRecordConverter converter = new FileToRecordConverter(DataFactory.DEFAULT);
        return converter.dirToRecord(directory, dataSource);
    }

    public InputStream getContent(Record record, TaskContext taskContext) throws ImportingException {
        PropertyNameMapper mapper = PropertyNameMapper.createFrom((TaskContext)taskContext);
        String path = record.getMetadata().getStringValue((String)mapper.get("filePath").get(0));
        if (path == null) {
            throw new IllegalArgumentException("Record '" + record.getId() + "' does not contain attribute '" + (String)mapper.get("filePath").get(0) + "'");
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new ImportingException("File '" + file + "' does not exist.");
        }
        if (!file.canRead()) {
            throw new ImportingException("File '" + file + "' is not readable.");
        }
        if (!file.isFile()) {
            throw new ImportingException("File '" + file + "' is not a file with content.");
        }
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new ImportingException("File '" + file + "' does not exist or is not readable.", (Throwable)ex, false);
        }
    }

    @Override
    public Set<String> getFilePropertyNames() {
        return this._filePropertyNames;
    }
}

