/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.crawler.file.internal;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.DataFactory;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.Value;
import org.eclipse.smila.importing.util.FilePathNormalizer;

public final class FileToRecordConverter {
    private final DataFactory _factory;

    public FileToRecordConverter(DataFactory factory) {
        this._factory = factory;
    }

    public Record fileToRecord(File file, String dataSource, boolean withContent) throws IOException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("parameter file is a directory");
        }
        Record record = this.createRecord(file, dataSource);
        this.addFileProperties(file, record);
        record.getMetadata().put("_deltaHash", Long.toString(file.lastModified()));
        if (withContent) {
            this.addAttachment(record, "filePath", "fileContent");
        }
        return record;
    }

    public Record dirToRecord(File directory, String dataSource) {
        if (directory.isFile()) {
            throw new IllegalArgumentException("parameter directory is not a directory");
        }
        Record record = this.createRecord(directory, dataSource);
        record.getMetadata().put("fileFolder", directory.getAbsolutePath());
        return record;
    }

    public void addAttachment(Record record, String pathAttribute, String attachmentName) throws IOException {
        String path = record.getMetadata().getStringValue(pathAttribute);
        if (path == null) {
            throw new IllegalArgumentException("Record '" + record.getId() + "' does not contain attribute '" + pathAttribute + "'");
        }
        record.setAttachment(attachmentName, FileUtils.readFileToByteArray((File)new File(path)));
    }

    private Record createRecord(File file, String dataSource) {
        return this._factory.createRecord(String.valueOf(dataSource) + ":" + file.getAbsolutePath(), dataSource);
    }

    private void addFileProperties(File file, Record record) {
        record.getMetadata().put("fileName", file.getName());
        record.getMetadata().put("filePath", FilePathNormalizer.getNormalizedPath((String)file.getAbsolutePath()));
        if (file.getParent() != null) {
            record.getMetadata().put("fileFolder", FilePathNormalizer.getNormalizedPath((String)file.getParent()));
        }
        record.getMetadata().put("fileSize", (Number)file.length());
        Value lastModifiedDate = this._factory.createDateTimeValue(new Date(file.lastModified()));
        record.getMetadata().put("fileLastModified", (Any)lastModifiedDate);
        record.getMetadata().put("fileExtension", FilenameUtils.getExtension((String)file.getName()));
    }
}

