/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.bpel.activities;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.rtrep.common.extension.AbstractExtensionBundle;
import org.apache.ode.bpel.rtrep.common.extension.ExtensionContext;
import org.apache.ode.utils.DOMUtils;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.datamodel.xml.XmlSerializationUtils;
import org.eclipse.smila.ode.ODEServer;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.PipeletTrackerListener;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.bpel.RequestTable;
import org.eclipse.smila.processing.bpel.activities.PipeletExtensionBundle;
import org.eclipse.smila.processing.bpel.activities.PipeletHolder;
import org.eclipse.smila.processing.bpel.counter.ProcessingPerformanceCounter;
import org.eclipse.smila.processing.bpel.internal.ExtensionBundleProvider;
import org.eclipse.smila.processing.bpel.util.MessageHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class PipeletManager
implements PipeletTrackerListener,
ExtensionBundleProvider {
    private final Map<String, Class<? extends Pipelet>> _activePipeletClasses = new HashMap<String, Class<? extends Pipelet>>();
    private final Map<String, PipeletHolder> _pipeletHolderMap = new HashMap<String, PipeletHolder>();
    private RequestTable _requests;
    private final Log _log = LogFactory.getLog(this.getClass());

    @Override
    public AbstractExtensionBundle getExtensionBundle() {
        PipeletExtensionBundle bundle = PipeletExtensionBundle.getInstance();
        bundle.setPipeletManager(this);
        return bundle;
    }

    public void invokeActivity(String activityKey, ExtensionContext context, Element element) {
        long startTime = System.nanoTime();
        ProcessingPerformanceCounter counter = null;
        boolean success = false;
        ClassLoader tcclBackup = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ODEServer.class.getClassLoader());
        try {
            try {
                PipeletHolder pipeletHolder = this._pipeletHolderMap.get(activityKey);
                if (pipeletHolder == null) {
                    throw new ProcessingException("no registration found for key: " + activityKey);
                }
                counter = pipeletHolder.getCounter();
                this.invokePipelet(context, activityKey, pipeletHolder);
                context.complete();
                success = true;
            }
            catch (Exception ex) {
                if (counter != null) {
                    counter.addError(ex, false);
                }
                context.completeWithFault((Throwable)ex);
                if (counter != null) {
                    counter.countInvocationNanos(System.nanoTime() - startTime, success, 0, 0);
                }
                Thread.currentThread().setContextClassLoader(tcclBackup);
            }
        }
        finally {
            if (counter != null) {
                counter.countInvocationNanos(System.nanoTime() - startTime, success, 0, 0);
            }
            Thread.currentThread().setContextClassLoader(tcclBackup);
        }
    }

    private void invokePipelet(ExtensionContext context, String key, PipeletHolder pipeletHolder) throws ProcessingException {
        String requestId = null;
        try {
            String inputVariableName = pipeletHolder.getInputVariable();
            String indexVariableName = pipeletHolder.getIndexVariable();
            String outputVariableName = pipeletHolder.getOutputVariable();
            if (outputVariableName == null && indexVariableName == null) {
                outputVariableName = inputVariableName;
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)(String.valueOf(key) + ": invoking " + pipeletHolder.getPrintName() + ", processing " + inputVariableName + " -> " + outputVariableName));
            }
            Element inputVariable = (Element)context.readVariable(inputVariableName);
            MessageHelper messageHelper = this._requests.getMessageHelper();
            requestId = messageHelper.parseRequestId(inputVariable);
            Node indexVariable = null;
            if (indexVariableName != null) {
                indexVariable = context.readVariable(indexVariableName);
            }
            if (this._log.isDebugEnabled()) {
                this.logVariable(key, "input", inputVariable);
                this.logVariable(key, "index", indexVariable);
            }
            this.checkAvailability(pipeletHolder);
            Blackboard blackboard = this._requests.getBlackboard(requestId);
            String[] request = messageHelper.parseMessage(blackboard, inputVariable, indexVariable);
            String[] result = this.doInvoke(pipeletHolder, blackboard, request);
            if (outputVariableName != null) {
                Element outputVariable = messageHelper.createMessage(blackboard, result, requestId);
                if (this._log.isDebugEnabled()) {
                    this.logVariable(key, "output", outputVariable);
                }
                context.writeVariable(outputVariableName, (Node)outputVariable);
            }
        }
        catch (Exception ex) {
            throw this.newProcessingException(ex, key, requestId);
        }
    }

    private void checkAvailability(PipeletHolder pipeletHolder) throws ProcessingException {
        Pipelet pipelet = pipeletHolder.getPipelet();
        if (pipelet == null) {
            throw new ProcessingException("Pipelet of class " + pipeletHolder.getClassName() + " for activity " + pipeletHolder.getKey() + " is not yet instantiated.");
        }
    }

    private void logVariable(String key, String name, Node variable) {
        if (variable != null) {
            String variableString = DOMUtils.domToString((Node)variable);
            this._log.debug((Object)(String.valueOf(key) + ": " + name + " = " + variableString));
        }
    }

    private String[] doInvoke(PipeletHolder pipeletHolder, Blackboard blackboard, String[] request) throws ProcessingException {
        int incomingIds = 0;
        int outgoingIds = 0;
        try {
            Pipelet pipelet = pipeletHolder.getPipelet();
            incomingIds = this.getRecordCount(request);
            String[] result = pipelet.process(blackboard, request);
            outgoingIds = this.getRecordCount(result);
            if (this._log.isTraceEnabled()) {
                if (result == null) {
                    this._log.trace((Object)"piplet result records: none");
                } else {
                    String[] stringArray = result;
                    int n = result.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id = stringArray[n2];
                        try {
                            this._log.trace((Object)("piplet result record: " + id + XmlSerializationUtils.serialize2string((Record)blackboard.getRecord(id))));
                        }
                        catch (Exception exception) {
                            this._log.trace((Object)("piplet result record: " + id + "error while serializing record"));
                        }
                        ++n2;
                    }
                }
            }
            String[] stringArray = result;
            return stringArray;
        }
        finally {
            if (pipeletHolder.getCounter() != null) {
                pipeletHolder.getCounter().countIds(incomingIds, outgoingIds);
            }
        }
    }

    private int getRecordCount(String[] recordIds) {
        if (recordIds != null) {
            return recordIds.length;
        }
        return 0;
    }

    private ProcessingException newProcessingException(Exception cause, String key, String requestId) {
        Exception causeToReport;
        String message;
        if (cause instanceof ProcessingException) {
            message = "Invocation of pipeline element " + key + " failed due to pipelet error: " + cause.getMessage();
            causeToReport = cause.getCause() == null ? cause : cause.getCause();
        } else {
            message = cause instanceof FaultException || cause instanceof ExternalVariableModuleException ? "Invocation of pipeline element " + key + " failed due to BPEL variable access error." : "Invocation of pipeline element " + key + " failed due to runtime error.";
            causeToReport = cause;
        }
        ProcessingException procEx = new ProcessingException(message, (Throwable)causeToReport);
        if (requestId == null) {
            this._log.warn((Object)message, (Throwable)causeToReport);
        } else {
            this._requests.setPipeletException(requestId, (Exception)((Object)procEx));
        }
        return procEx;
    }

    public void registerActivity(PipeletHolder pipelet) throws ProcessingException {
        String activityKey = pipelet.getKey();
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)(String.valueOf(activityKey) + ": found " + pipelet.getPrintName() + ", processing " + pipelet.getInputVariable() + " -> " + pipelet.getOutputVariable() + (pipelet.getIndexVariable() == null ? "" : ", using loop variable " + pipelet.getIndexVariable())));
            if (pipelet.getConfiguration() == null) {
                this._log.info((Object)(String.valueOf(activityKey) + ": no pipelet configuration found."));
            } else {
                this._log.info((Object)(String.valueOf(activityKey) + ": pipelet configuration parsed."));
            }
        }
        this.initPipeletInstance(pipelet);
        this._pipeletHolderMap.put(activityKey, pipelet);
    }

    private void initPipeletInstance(PipeletHolder instance) throws ProcessingException {
        String className;
        if (instance.getPipelet() == null && this._activePipeletClasses.containsKey(className = instance.getClassName())) {
            Class<? extends Pipelet> pipeletClass = this._activePipeletClasses.get(className);
            try {
                Pipelet pipelet = pipeletClass.newInstance();
                if (instance.getConfiguration() != null) {
                    ClassLoader tcclBackup = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(ODEServer.class.getClassLoader());
                    try {
                        pipelet.configure(instance.getConfiguration());
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(tcclBackup);
                    }
                }
                instance.setPipelet(pipelet);
            }
            catch (InstantiationException e) {
                throw new ProcessingException("error instantiating pipelet class " + className, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ProcessingException("error instantiating pipelet class " + className, (Throwable)e);
            }
        }
    }

    public void pipeletsAdded(Map<String, Class<? extends Pipelet>> pipeletClasses) {
        this._log.info((Object)("Pipelets have been added: " + pipeletClasses.keySet()));
        this._activePipeletClasses.putAll(pipeletClasses);
        for (PipeletHolder holder : this._pipeletHolderMap.values()) {
            try {
                this.initPipeletInstance(holder);
            }
            catch (ProcessingException ex) {
                this._log.error((Object)"error when initializing pending pipelet", (Throwable)ex);
            }
        }
    }

    public void pipeletsRemoved(Map<String, Class<? extends Pipelet>> pipeletClasses) {
        this._log.info((Object)("Pipelets have been removed: " + pipeletClasses.keySet()));
        for (PipeletHolder holder : this._pipeletHolderMap.values()) {
            if (!pipeletClasses.containsKey(holder.getClassName())) continue;
            holder.setPipelet(null);
        }
        for (String className : pipeletClasses.keySet()) {
            this._activePipeletClasses.remove(className);
        }
    }

    public void setRequestTable(RequestTable requests) {
        this._requests = requests;
    }

    public void unsetRequestTable(RequestTable requests) {
        if (this._requests == requests) {
            this._requests = null;
        }
    }
}

