/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.processing.pipelets;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.blackboard.Blackboard;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnyMap;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.ipc.IpcAnyWriter;
import org.eclipse.smila.processing.Pipelet;
import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.parameters.ParameterAccessor;
import org.eclipse.smila.processing.pipelets.SourceType;
import org.eclipse.smila.processing.util.ResultCollector;

public class JSONWriterPipelet
implements Pipelet {
    public static final String INPUT_ATTRIBUTES_PROPERTY = "inputAttributes";
    public static final String OUTPUT_NAME_PROPERTY = "outputName";
    public static final String OUTPUT_TYPE_PROPERTY = "outputType";
    public static final String PRINT_PRETTY_PROPERTY = "printPretty";
    private List<String> _inputAttributes;
    private boolean _plain;
    private String _outputName;
    private SourceType _outputType;
    private boolean _printPretty;
    private AnyMap _config;
    private final Log _log = LogFactory.getLog(this.getClass());

    public void configure(AnyMap config) throws ProcessingException {
        this._config = config;
        ParameterAccessor paramAccessor = new ParameterAccessor(config);
        this._inputAttributes = paramAccessor.getParameters(INPUT_ATTRIBUTES_PROPERTY);
        this._plain = !(config.get((Object)INPUT_ATTRIBUTES_PROPERTY) instanceof AnySeq);
        this._outputName = paramAccessor.getRequiredParameter(OUTPUT_NAME_PROPERTY);
        String outputType = paramAccessor.getRequiredParameter(OUTPUT_TYPE_PROPERTY);
        try {
            this._outputType = SourceType.valueOf(outputType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ProcessingException("Illegal value for output type: " + outputType);
        }
        this._printPretty = paramAccessor.getBooleanParameter(PRINT_PRETTY_PROPERTY, Boolean.TRUE);
    }

    public String[] process(Blackboard blackboard, String[] recordIds) throws ProcessingException {
        ResultCollector results = new ResultCollector(new ParameterAccessor(this._config), this._log, false);
        IpcAnyWriter writer = new IpcAnyWriter(this._printPretty);
        String[] stringArray = recordIds;
        int n = recordIds.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            try {
                Object object;
                AnyMap metadata = blackboard.getMetadata(id);
                if (this._plain) {
                    object = this._inputAttributes.size() == 0 ? metadata : (Any)metadata.get((Object)this._inputAttributes.get(0));
                } else {
                    AnyMap map = blackboard.getDataFactory().createAnyMap();
                    for (String attribute : this._inputAttributes) {
                        if (!metadata.containsKey((Object)attribute)) continue;
                        map.put(attribute, (Any)metadata.get((Object)attribute));
                    }
                    object = map;
                }
                if (this._outputType == SourceType.ATTACHMENT) {
                    ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                    writer.writeJsonStream((Any)object, (OutputStream)buffer);
                    blackboard.setAttachment(id, this._outputName, buffer.toByteArray());
                } else {
                    metadata.put(this._outputName, writer.writeJsonObject((Any)object));
                }
                results.addResult(id);
            }
            catch (Exception e) {
                results.addFailedResult(id, e);
            }
            ++n2;
        }
        return results.getResultIds();
    }
}

