/*******************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - initial API and implementation
 *******************************************************************************/
package org.eclipse.smila.http.client.impl;

import java.io.IOException;

import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.eclipse.smila.http.client.impl.base.HttpRequestExecutor;

/** implementation used by {@link DefaultRestClient}. */
public class DefaultHttpRequestExecutor implements HttpRequestExecutor {

  /** the host and port we are talking to. */
  private final String _hostAndPort;

  /** create instance. */
  public DefaultHttpRequestExecutor(final String hostAndPort) {
    if (hostAndPort.toLowerCase().startsWith("http://")) {
      _hostAndPort = hostAndPort;
    } else {
      _hostAndPort = "http://" + hostAndPort;
    }
  }

  @Override
  public String getHostAndPort() {
    return _hostAndPort;
  }

  @Override
  public HttpResponse execute(final HttpClient client, final HttpUriRequest request) throws IOException {
    return client.execute(request);
  }
}
