/***********************************************************************************************************************
 * Copyright (c) 2008, 2012 Attensity Europe GmbH and brox IT Solutions GmbH. All rights reserved. This program and the
 * accompanying materials are made available under the terms of the Eclipse Public License v1.0 which accompanies this
 * distribution, and is available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Juergen Schumacher (Attensity Europe GmbH) - implementation
 **********************************************************************************************************************/
package org.eclipse.smila.processing.bpel;

import org.eclipse.smila.processing.ProcessingException;
import org.eclipse.smila.processing.WorkflowProcessor;

/** service interface for workflow update watchers. */
public interface WorkflowUpdateWatcher {
  /** register a workflow processor to be notified on updates. */
  void registerProcessor(WorkflowProcessor processor);

  /**
   * install a ZK watch on the root node to get notifications about changes.
   * 
   * @return true if watched was installed successfully
   */
  boolean startWatching();

  /**
   * stop watching: ZK watch on root node will not be reinstalled. Does not remove a currently installed watch, so it's
   * possible that remaining watches will still receive notifications after this call.
   */
  void stopWatching();

  /** start polling for updates. */
  void startPolling();

  /** start polling for updates with custom interval. */
  void startPolling(final int pollIntervalSeconds);

  /** stop polling for updates. */
  void stopPolling();

  /**
   * Initialize notification structure for workflow, call on initial load on service start. Does not trigger
   * notifications for other nodes, just ensure that the node is created.
   */
  void workflowLoadedOnStart(final String workflowName, final String timestamp) throws ProcessingException;

  /** Send update notification, call on custom workflow creation or update. */
  void workflowUpdated(final String workflowName, final String timestamp) throws ProcessingException;

  /** Send delete notification, call on custom workflow remove. */
  void workflowDeleted(final String workflowName) throws ProcessingException;

  /** compare cluster versions of workflows with local versions and update local deployment. */
  void checkWorkflowVersions();

}
