/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smila.importing.compounds;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.smila.datamodel.Any;
import org.eclipse.smila.datamodel.AnySeq;
import org.eclipse.smila.datamodel.Record;
import org.eclipse.smila.importing.ContentFetcher;
import org.eclipse.smila.importing.ImportingException;
import org.eclipse.smila.importing.compounds.CompoundExtractor;
import org.eclipse.smila.importing.compounds.CompoundExtractorException;
import org.eclipse.smila.objectstore.ObjectStoreException;
import org.eclipse.smila.taskworker.TaskContext;
import org.eclipse.smila.taskworker.Worker;
import org.eclipse.smila.taskworker.input.RecordInput;
import org.eclipse.smila.taskworker.output.RecordOutput;
import org.eclipse.smila.utils.MaybeRecoverableException;

public abstract class ExtractorWorkerBase
implements Worker {
    private static final String INPUT_SLOT = "compounds";
    private static final String OUTPUT_SLOT = "files";
    private CompoundExtractor _extractor;
    private final Log _log = LogFactory.getLog(this.getClass());

    public void perform(TaskContext taskContext) throws Exception {
        Record compoundRecord;
        RecordInput recordInput = taskContext.getInputs().getAsRecordInput(INPUT_SLOT);
        RecordOutput recordOutput = taskContext.getOutputs().getAsRecordOutput(OUTPUT_SLOT);
        do {
            if ((compoundRecord = recordInput.getRecord()) == null) continue;
            try {
                this.extractCompound(compoundRecord, recordOutput, taskContext);
            }
            catch (MaybeRecoverableException ex) {
                if (ex.isRecoverable()) {
                    throw ex;
                }
                taskContext.getLog().error("Failed to extract compound " + compoundRecord.getId(), (Throwable)ex);
            }
            catch (RuntimeException ex) {
                taskContext.getLog().error("Failed to extract compound " + compoundRecord.getId(), (Throwable)ex);
            }
        } while (compoundRecord != null && !taskContext.isCanceled());
    }

    private void extractCompound(Record compoundRecord, RecordOutput recordOutput, TaskContext taskContext) throws MaybeRecoverableException, ObjectStoreException, IOException {
        InputStream compoundContent;
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("extracting compound " + compoundRecord.getId()));
        }
        if ((compoundContent = this.getCompoundContentTimed(compoundRecord, taskContext)) != null) {
            try {
                Iterator<Record> entryRecords = this.invokeExtractorTimed(compoundRecord, compoundContent, taskContext);
                this.extractEntries(compoundRecord, entryRecords, recordOutput, taskContext);
            }
            finally {
                IOUtils.closeQuietly((InputStream)compoundContent);
            }
        }
    }

    private InputStream getCompoundContentTimed(Record compoundRecord, TaskContext taskContext) throws ImportingException {
        long startTime = taskContext.getTimestamp();
        try {
            InputStream inputStream = this.getContentFetcher().getContent(compoundRecord, taskContext);
            return inputStream;
        }
        finally {
            taskContext.measureTime("fetchCompoundContent", startTime);
        }
    }

    private Iterator<Record> invokeExtractorTimed(Record compoundRecord, InputStream compoundContent, TaskContext taskContext) throws CompoundExtractorException {
        long startTime = taskContext.getTimestamp();
        try {
            Iterator<Record> iterator = this.invokeExtractor(this._extractor, compoundRecord, compoundContent, taskContext);
            return iterator;
        }
        finally {
            taskContext.measureTime("extractCompound", startTime);
        }
    }

    private void extractEntries(Record compoundRecord, Iterator<Record> entryRecords, RecordOutput recordOutput, TaskContext taskContext) throws MaybeRecoverableException, ObjectStoreException, IOException {
        long startTime = taskContext.getTimestamp();
        while (entryRecords.hasNext() && !taskContext.isCanceled()) {
            Record entryRecord = entryRecords.next();
            taskContext.measureTime("extractCompound", startTime);
            Record convertedRecord = this.convertRecordTimed(compoundRecord, entryRecord, taskContext);
            if (convertedRecord != null) {
                recordOutput.writeRecord(convertedRecord);
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("added record " + entryRecord.getId()));
                }
            }
            startTime = taskContext.getTimestamp();
        }
    }

    private Record convertRecordTimed(Record compoundRecord, Record extractedRecord, TaskContext taskContext) {
        long startTime = taskContext.getTimestamp();
        try {
            Record convertedRecord = this.convertRecord(compoundRecord, extractedRecord, taskContext);
            if (convertedRecord != null) {
                this.copyCompoundAttributes(compoundRecord, extractedRecord, convertedRecord);
            }
            if (!this.filterRecord(convertedRecord, taskContext)) {
                return null;
            }
            this.mapRecord(convertedRecord, taskContext);
            Record record = convertedRecord;
            return record;
        }
        finally {
            taskContext.measureTime("convertRecord", startTime);
        }
    }

    protected void mapRecord(Record record, TaskContext taskContext) {
    }

    protected boolean filterRecord(Record record, TaskContext taskContext) {
        return true;
    }

    protected abstract Iterator<Record> invokeExtractor(CompoundExtractor var1, Record var2, InputStream var3, TaskContext var4) throws CompoundExtractorException;

    protected abstract Record convertRecord(Record var1, Record var2, TaskContext var3);

    protected abstract ContentFetcher getContentFetcher();

    protected void copyAttachment(Record sourceRecord, Record targetRecord, String attachmentName) {
        if (sourceRecord.hasAttachment(attachmentName)) {
            targetRecord.setAttachment(sourceRecord.getAttachment(attachmentName));
        }
    }

    protected void copyAttribute(Record sourceRecord, String sourceAttribute, Record targetRecord, String targetAttribute) {
        Any sourceAttributeValue = (Any)sourceRecord.getMetadata().get((Object)sourceAttribute);
        if (sourceAttributeValue != null) {
            targetRecord.getMetadata().put(targetAttribute, sourceAttributeValue);
        }
    }

    protected void copySetToStringAttribute(Record sourceRecord, String sourceAttribute, Record targetRecord, String targetAttribute, String separator) {
        Any sourceAttributeValue = (Any)sourceRecord.getMetadata().get((Object)sourceAttribute);
        if (sourceAttributeValue != null) {
            if (sourceAttributeValue.isSeq()) {
                AnySeq seq = sourceAttributeValue.asSeq();
                StringBuilder newValueBuilder = new StringBuilder();
                for (Any value : seq) {
                    newValueBuilder.append(value.asValue().asString()).append(separator);
                }
                String newValue = newValueBuilder.toString();
                newValue = newValue.substring(0, newValue.lastIndexOf(separator));
                targetRecord.getMetadata().put(targetAttribute, newValue);
            } else if (sourceAttributeValue.isValue()) {
                targetRecord.getMetadata().put(targetAttribute, sourceAttributeValue);
            }
        }
    }

    protected void concatAttributeValues(Record sourceRecord, String sourceAttribute, Record targetRecord, String targetAttribute, String separator) {
        Any sourceAttributeValue = (Any)sourceRecord.getMetadata().get((Object)sourceAttribute);
        Any targetAttributeValue = (Any)targetRecord.getMetadata().get((Object)targetAttribute);
        if (sourceAttributeValue != null && sourceAttributeValue.isValue()) {
            if (targetAttributeValue == null) {
                targetRecord.getMetadata().put(targetAttribute, sourceAttributeValue);
            } else if (targetAttributeValue.isString()) {
                String concatenatedValue = String.valueOf(targetAttributeValue.asValue().asString()) + separator + sourceAttributeValue.asValue().asString();
                targetRecord.getMetadata().put(targetAttribute, concatenatedValue);
            }
        }
    }

    protected void copyCompoundAttributes(Record compoundRecord, Record extractedRecord, Record convertedRecord) {
        this.copyAttribute(extractedRecord, "isCompound", convertedRecord, "_isCompound");
        this.copyAttribute(extractedRecord, INPUT_SLOT, convertedRecord, "_compoundPath");
        if (!extractedRecord.getMetadata().containsKey((Object)"isRootCompound")) {
            this.copyAttribute(compoundRecord, "_recordid", convertedRecord, "_compoundRecordId");
        }
    }

    public void setCompoundExtractor(CompoundExtractor extractor) {
        this._extractor = extractor;
    }

    public void unsetCompoundExtractor(CompoundExtractor extractor) {
        if (this._extractor == extractor) {
            this._extractor = null;
        }
    }
}

